--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    SCORE, AEROPLANE, BULLETS, APPEARANCE_MANAGER,
    FCTM_ETHERNET_PARTNER, INFO_MANAGER, NYI,
    LOGICAL_TO_BOOLEAN, LOGICAL_TO_STRING,
    FLIGHT_RECORDER, RIBBON_MANAGER,
    ETHERNET, MESSAGE_MANAGER, COMPRESSED_ORIENTATION_MANAGER,
    SCALAR_PHYSICS, OBJECT_PHYSICS, WORLD_PHYSICS,
    UNCHECKED_DEALLOCATION, TEXT_IO,
    SYSTEM;

use 
    ETHERNET, MESSAGE_MANAGER, COMPRESSED_ORIENTATION_MANAGER;

pragma ELABORATE(
    SCORE,
    APPEARANCE_MANAGER,
    FCTM_ETHERNET_PARTNER, INFO_MANAGER, NYI,
    LOGICAL_TO_BOOLEAN, LOGICAL_TO_STRING,
    FLIGHT_RECORDER, RIBBON_MANAGER,
    ETHERNET, MESSAGE_MANAGER, COMPRESSED_ORIENTATION_MANAGER,
    SCALAR_PHYSICS, OBJECT_PHYSICS, WORLD_PHYSICS,
    UNCHECKED_DEALLOCATION, TEXT_IO,
    SYSTEM);

separate(MAIN_SIMULATION.OBJECT_SYNC)

    package body MULTIPLAYER_SUPPORT is

	HAS_MULTIPLAYERS : BOOLEAN := FALSE;

	type LIST_OF_ACCESS_OUTPUT_CHANNEL_TYPE;

	type ACCESS_LIST_OF_ACCESS_OUTPUT_CHANNEL_TYPE is
	    access LIST_OF_ACCESS_OUTPUT_CHANNEL_TYPE;

	type LIST_OF_ACCESS_OUTPUT_CHANNEL_TYPE is
	    record
		NEXT		: ACCESS_LIST_OF_ACCESS_OUTPUT_CHANNEL_TYPE;
		OC		: ACCESS_OUTPUT_CHANNEL_TYPE;
		REMOTE_NUMBER	: REMOTE_NUMBER_TYPE;
	    end record;

	IC  : ACCESS_INPUT_CHANNEL_TYPE;
	LOC : ACCESS_LIST_OF_ACCESS_OUTPUT_CHANNEL_TYPE; 


	type RECEIVED_OBJECT_TYPE;
	type ACCESS_RECEIVED_OBJECT_TYPE is access RECEIVED_OBJECT_TYPE;
	type RECEIVED_OBJECT_TYPE is
	    record
		NEXT			: ACCESS_RECEIVED_OBJECT_TYPE;
		ORIGINAL_REMOTE_NUMBER	: REMOTE_NUMBER_TYPE;
		REMOTE_NUMBER		: REMOTE_NUMBER_TYPE;
		REMOTE_SEQUENCE_NUMBER	: POSITIVE;
		REMOTE_OBJECT_INFO	: INFO_MANAGER.OBJECT_INFO_TYPE;
		OBJECT			: OBJECTS.ACCESS_OBJECT_TYPE;
		COUNT_DOWN		: NATURAL;
		HEARD_FROM		: BOOLEAN;
		HIT_AT_LEAST_ONCE	: BOOLEAN;
	    end record;

	SOMETHING_INTERESTING_HAPPENED : BOOLEAN := FALSE;

	FROM_FLIGHT_RECORDER : BOOLEAN := FALSE;

	subtype HASHED_REMOTE_SEQUENCE_SUBTYPE is
	    POSITIVE range 1..31;

	RECEIVED_OBJECTS_LISTS	:
	    array(HASHED_REMOTE_SEQUENCE_SUBTYPE)
	    of ACCESS_RECEIVED_OBJECT_TYPE;


	package IDENTIFY_TAPE_OBJECTS is
	    procedure DO_IT;
	end;

	function HASH_REMOTE_SEQUENCE(RS : POSITIVE) return
	    HASHED_REMOTE_SEQUENCE_SUBTYPE;


	procedure DEALLOCATE is
	    new UNCHECKED_DEALLOCATION(
		    RECEIVED_OBJECT_TYPE,
		    ACCESS_RECEIVED_OBJECT_TYPE);


	function "="(LEFT, RIGHT : FLIGHT_RECORDER.STATE_TYPE) return BOOLEAN
	    renames FLIGHT_RECORDER."=";


	function START_COUNT_DOWN(OBJ : OBJECT_TYPE) return NATURAL is
	begin
	    if OBJ.CLASS in TARGET_CLASS_SUBTYPE then
		return 5;
	    else
		return 2;
	    end if;
	end;


	function HASH_REMOTE_SEQUENCE(RS : POSITIVE) return
	    HASHED_REMOTE_SEQUENCE_SUBTYPE is
	begin
	    return (RS rem HASHED_REMOTE_SEQUENCE_SUBTYPE'last) + 1;
	end;


	procedure RECEIVE_AN_ITEM(
	    MESSAGE_ITEM    : in out MESSAGE_ITEM_TYPE;
	    REMOTE_NUMBER   : REMOTE_NUMBER_TYPE;
	    ORIGINAL_RN     : REMOTE_NUMBER_TYPE) is
	begin
	    case MESSAGE_ITEM.REASON is

		when NONE =>
		    null;

		when OBJECT_HERE|CREATE_MISSILE =>
		    declare
			use INFO_MANAGER, OBJECTS;
			O : ACCESS_OBJECT_TYPE := null;
			ARO : ACCESS_RECEIVED_OBJECT_TYPE;
			REMOTE_SEQUENCE_NUMBER : constant POSITIVE :=
			    MESSAGE_ITEM.SEQUENCE_NUMBER;
			REMOTE_OBJECT_INFO : constant OBJECT_INFO_TYPE :=
			    MESSAGE_ITEM.OBJECT_INFO;

			RECEIVED_OBJECTS_LIST : ACCESS_RECEIVED_OBJECT_TYPE
			    renames RECEIVED_OBJECTS_LISTS(
				HASH_REMOTE_SEQUENCE(REMOTE_SEQUENCE_NUMBER));

		    begin
			-- Try to find this as an existing object in this simulation
			--
			ARO := RECEIVED_OBJECTS_LIST;
			while ARO /= null loop
			    declare
				RO : RECEIVED_OBJECT_TYPE renames ARO.all;
			    begin
				if  RO.REMOTE_NUMBER = REMOTE_NUMBER
				and RO.REMOTE_OBJECT_INFO = REMOTE_OBJECT_INFO
				and RO.REMOTE_SEQUENCE_NUMBER = REMOTE_SEQUENCE_NUMBER
				then
				    O := RO.OBJECT;
				    exit;
				end if;
				ARO := RO.NEXT;
			    end;
			end loop;

			-- If not, then add it
			--
			if ARO = null then

			    declare
				ORIENTATION : WORLD_PHYSICS.POSITION_BASIS;
			    begin

				DECOMPRESS(MESSAGE_ITEM.ORIENTATION, ORIENTATION);

				O := CREATE(ANOTHER_SIMULATOR,
					    MESSAGE_ITEM.CLASS,
					    MESSAGE_ITEM.SUBCLASS,
					    MESSAGE_ITEM.LOCATION,
					    ORIENTATION,
					    (0.0, 0.0, 0.0));

			    end;

			    ADD_ONE_OBJECT(O);

			    ARO := new RECEIVED_OBJECT_TYPE'(
					RECEIVED_OBJECTS_LIST,
					ORIGINAL_RN,
					REMOTE_NUMBER,
					REMOTE_SEQUENCE_NUMBER,	
					REMOTE_OBJECT_INFO,
					O,
					START_COUNT_DOWN(O.all),
					FALSE,
					FALSE);

			    RECEIVED_OBJECTS_LIST := ARO;

			elsif ARO.HEARD_FROM
			and MESSAGE_ITEM.CLASS = OBJECTS.BULLETS
			then
			    -- ignore multiple messages from bullets
			    --
			    return;
			end if;

			-- Update the various aspects
			--
			declare
			    OBJ : OBJECT_TYPE renames O.all;
			begin
			    ARO.COUNT_DOWN	:= START_COUNT_DOWN(OBJ);

			    OBJ.CLASS		:= MESSAGE_ITEM.CLASS;

			    -- if heard from more than once per scan, don't
			    -- quantum leap to the beginning of the last message
			    --
			    if not ARO.HEARD_FROM then
				ARO.HEARD_FROM	    := TRUE;
				OBJ.OLD_LOCATION    := OBJ.LOCATION;
			    end if;

			    OBJ.LOCATION	:= MESSAGE_ITEM.LOCATION;
			    DECOMPRESS(MESSAGE_ITEM.ORIENTATION, OBJ.ORIENTATION);
			    OBJ.APPEARANCE_INFO := MESSAGE_ITEM.APPEARANCE_INFO ;
			    OBJ.CLASS_INFO	:= MESSAGE_ITEM.CLASS_INFO;
			    OBJ.SUBCLASS	:= MESSAGE_ITEM.SUBCLASS;

			    -- Update the message to reflect its local meaning
			    -- This is so that the flight recording will have
			    -- these consistent.
			    --
			    if FROM_FLIGHT_RECORDER then
				if OBJ.APPEARANCE_INFO =
				    BULLETS.BULLET_APPEARANCE_INFO
				then
				    OBJ.APPEARANCE_INFO :=
					BULLETS.BULLET_APPEARANCE_FROM_TAPE_INFO;
				end if;
			    else
				MESSAGE_ITEM.SEQUENCE_NUMBER := OBJ.SEQUENCE_NUMBER;
				MESSAGE_ITEM.OBJECT_INFO     := OBJ.OBJECT_INFO;
			    end if;
			end;

			-- draw the ribbon if needed
			--
			if O.CLASS /= OBJECTS.AEROPLANE
			or RIBBON_MANAGER.LENGTH = 0
			then
			    null;
			elsif FROM_FLIGHT_RECORDER then
			    if FLIGHT_RECORDER.SPEED > 0 then
				RIBBON_MANAGER.EXTEND(O.all);
			    end if;
			elsif not RIBBON_MANAGER.ONLY_FROM_FLIGHT_RECORDER then
			    RIBBON_MANAGER.EXTEND(O.all);
			end if;

		    end;

		when HIT_BY_BULLETS|HIT_BY_OBJECT =>
		    declare
			AO  : constant ACCESS_OBJECT_TYPE
			    := TO_ACCESS_OBJECT_TYPE(
				    MESSAGE_ITEM.HIT_OBJECT_INFO);
		    begin
			if AO /= null
			and then AO.SEQUENCE_NUMBER =
				    MESSAGE_ITEM.HIT_SEQUENCE_NUMBER
			and then not FROM_FLIGHT_RECORDER
			and then not AO.DELETE_PENDING
			then
			    SCORE.KILLED_BY(Natural(ORIGINAL_RN));
			    SET_DELETE_PENDING(AO);
			    SOMETHING_INTERESTING_HAPPENED := TRUE;
			end if;
		    end;

		when RADIO_TEXT =>
		    NYI("GENERIC_MULTIPLAYER_SUPPORT.RECEIVE_AN_ITEM : RADIO_TEXT",
			TRUE);

		when TIME_TO_QUIT =>
		    INSTRUMENTS.SET(INSTRUMENTS.MESSAGES, "quit");

	    end case;
	end;


	procedure RECEIVE(
	    MESSAGE         : in out MESSAGE_TYPE;
	    REMOTE_NUMBER   : REMOTE_NUMBER_TYPE
	    ) is
	begin

	    for N in 1..MESSAGE.NUMBER_OF_ITEMS loop
		RECEIVE_AN_ITEM(MESSAGE.ITEMS(N), REMOTE_NUMBER, REMOTE_NUMBER);
	    end loop;

	    if FLIGHT_RECORDER.STATE = FLIGHT_RECORDER.ON_RECORD
	    and FILTER_RECORDING.TO_FLIGHT_RECORDER
	    then
		FLIGHT_RECORDER.RECORD_MESSAGE(MESSAGE, REMOTE_NUMBER);
	    end if;

	end;

	package TRANSCEIVER is new GENERIC_TRANSCEIVER(MESSAGE_TYPE, RECEIVE);


	procedure PLAY_FLIGHT_RECORDER is
	    new FLIGHT_RECORDER.PLAY(RECEIVE_AN_ITEM);


	package body IDENTIFY_TAPE_OBJECTS is

	    ENABLED	: constant BOOLEAN
			:= LOGICAL_TO_BOOLEAN(
				"FCTM_IDENTIFY_TAPE_OBJECTS", TRUE);

	    MAX_IDS	: constant NATURAL
			:= 9;

	    subtype ID_SUBTYPE is NATURAL range 0..MAX_IDS;

	    ID_OBJECTS	: array(ID_SUBTYPE) of OBJECTS.ACCESS_OBJECT_TYPE;

	    function CREATE_APPEARANCE(
		ID	    : ID_SUBTYPE)
		return INFO_MANAGER.APPEARANCE_INFO_TYPE is

		use APPEARANCE_MANAGER, SCALAR_PHYSICS;

		APPEARANCE_INFO : constant INFO_MANAGER.APPEARANCE_INFO_TYPE
		    := CREATE;

		APPEARANCE : ACCESS_APPEARANCE_TYPE
		    := TO_ACCESS_APPEARANCE_TYPE(APPEARANCE_INFO);

		H : constant METRES := 200.0;
		W : constant METRES := 200.0;
		Z : constant METRES :=   0.0;
	    begin
		case ID is
		    when 0 =>
			ADD_POINTS(APPEARANCE, 
			    VECTOR_OF_POSITION'(
			    ( Z, Z, H),
			    ( W, Z, H+W),
			    ( Z, Z, H+W+W),
			    (-W, Z, H+W),
			    ( Z, Z, H))
			    );
		    when 1 =>
			ADD_POINTS(APPEARANCE, 
			    VECTOR_OF_POSITION'(
			    ( Z, Z, H),
			    ( Z, Z, H+W+W))
			    );
		    when 2 =>
			ADD_POINTS(APPEARANCE, 
			    VECTOR_OF_POSITION'(
			    (-W, Z, H+W+W),
			    ( W, Z, H+W+W),
			    (-W, Z, H),
			    ( W, Z, H))
			    );
		    when 3 =>
			ADD_POINTS(APPEARANCE, 
			    VECTOR_OF_POSITION'(
			    (-W, Z, H+W+W),
			    ( W, Z, H+W*METRES'(1.5)),
			    (-W, Z, H+W),
			    ( W, Z, H+W*METRES'(0.5)),
			    (-W, Z, H))
			    );
		    when 4 =>
			ADD_POINTS(APPEARANCE, 
			    VECTOR_OF_POSITION'(
			    ( Z, Z, H),
			    ( Z, Z, H+W+W),
			    (-W, Z, H+W),
			    ( W, Z, H+W))
			    );
		    when 5 =>
			ADD_POINTS(APPEARANCE, 
			    VECTOR_OF_POSITION'(
			    (-W, Z, H),
			    ( W, Z, H),
			    ( W, Z, H+W),
			    (-W, Z, H+W),
			    (-W, Z, H+W+W),
			    ( W, Z, H+W+W))
			    );
		    when 6 =>
			ADD_POINTS(APPEARANCE, 
			    VECTOR_OF_POSITION'(
			    (-W, Z, H+W),
			    ( W, Z, H+W),
			    ( W, Z, H),
			    (-W, Z, H),
			    (-W, Z, H+W+W),
			    ( W, Z, H+W+W))
			    );
		    when 7 =>
			ADD_POINTS(APPEARANCE, 
			    VECTOR_OF_POSITION'(
			    (-W, Z, H+W+W),
			    ( W, Z, H+W+W),
			    (-W, Z, H))
			    );
		    when 8 =>
			ADD_POINTS(APPEARANCE, 
			    VECTOR_OF_POSITION'(
			    (-W, Z, H+W+W),
			    ( W, Z, H+W+W),
			    (-W, Z, H),
			    ( W, Z, H),
			    (-W, Z, H+W+W))
			    );
		    when 9 =>
			ADD_POINTS(APPEARANCE, 
			    VECTOR_OF_POSITION'(
			    ( W, Z, H+W),
			    (-W, Z, H+W),
			    (-W, Z, H+W+W),
			    ( W, Z, H+W+W),
			    ( W, Z, H),
			    (-W, Z, H))
			    );
		end case;
		FINISH_CREATING_SUBPICTURES(APPEARANCE);
		return APPEARANCE_INFO;
	    end;

	    procedure PLACE_ID(
		ID	    : ID_SUBTYPE;
		LOCATION    : in OBJECT_LOCATION) is

		IDO	    : OBJECTS.ACCESS_OBJECT_TYPE renames ID_OBJECTS(ID);

	    begin
		if IDO = null then
		    IDO :=
			CREATE(NONE_NEEDED, BUILDING, 0,
			    (0.0, 0.0, 0.0),
			    WORLD_PHYSICS.USUAL_POSITION_BASIS,
			    (0.0, 0.0, 0.0));
		    IDO.APPEARANCE_INFO := CREATE_APPEARANCE(ID);
		    ADD_ONE_OBJECT(IDO);
		end if;
		IDO.LOCATION	:= LOCATION;
		IDO.ORIENTATION :=
		    VIEW_MANAGER.VIEW_POINT_READ_ONLY.ORIENTATION;
	    end;

	    procedure DO_IT is
	    begin
		if not ENABLED 
		or else CONTROLLED_OBJECT.OBJECT_TO_BE_CONTROLLED = null
		or else CONTROLLED_OBJECT.OBJECT_TO_BE_CONTROLLED.CLASS /=
		    MAGIC_CARPET
		then
		    -- HACK, at some time add code to delete ID's here
		    --
		    return;
		end if;

		for ROL_INDEX in RECEIVED_OBJECTS_LISTS'range loop
		    declare
			ARO : ACCESS_RECEIVED_OBJECT_TYPE
			    := RECEIVED_OBJECTS_LISTS(ROL_INDEX);
		    begin
			while ARO /= null loop
			    declare
				RO : RECEIVED_OBJECT_TYPE renames ARO.all;
			    begin
				if RO.OBJECT.CLASS in TARGET_CLASS_SUBTYPE then
				    PLACE_ID(
					INTEGER(RO.ORIGINAL_REMOTE_NUMBER) rem
					    (MAX_IDS+1),
					RO.OBJECT.LOCATION);
				end if;
				ARO := RO.NEXT;
			    end;
			end loop;
		    end;
		end loop;
	    end;

	end;


	procedure RECEIVE_UPDATES is
	    PREV, THIS, NEXT : ACCESS_RECEIVED_OBJECT_TYPE;
	begin
	    RIBBON_MANAGER.UPDATE_ALL_RIBBONS(ELAPSED_SINCE_LAST_ITERATION);

	    -- Receive messages from flight recorder and/or other players
	    --
	    if FLIGHT_RECORDER.STATE = FLIGHT_RECORDER.ON_PLAY then
		FROM_FLIGHT_RECORDER := TRUE;

		PLAY_FLIGHT_RECORDER(ELAPSED_SINCE_LAST_ITERATION);

		IDENTIFY_TAPE_OBJECTS.DO_IT;

		FROM_FLIGHT_RECORDER := FALSE;

	    elsif not HAS_MULTIPLAYERS then
		return;

	    end if;

	    if HAS_MULTIPLAYERS then
		TRANSCEIVER.RECEIVE_ALL_PENDING;
	    end if;

	    -- Delete all received objects we haven't heard from recently,
	    -- or which are being deleted this iteration
	    --
	    for ROL_INDEX in RECEIVED_OBJECTS_LISTS'range loop
		PREV := null;
		THIS := RECEIVED_OBJECTS_LISTS(ROL_INDEX);
		while THIS /= null loop
		    declare
			RO : RECEIVED_OBJECT_TYPE renames THIS.all;
		    begin
			NEXT := RO.NEXT;
                        RO.HEARD_FROM := FALSE;

			if RO.COUNT_DOWN = 0 then
			    SET_DELETE_PENDING(RO.OBJECT);
			elsif RO.REMOTE_NUMBER /=
			    FLIGHT_RECORDER.FLIGHT_RECORDER_REMOTE_NUMBER 
			or FLIGHT_RECORDER.SPEED /= 0
			or FLIGHT_RECORDER.STATE /= FLIGHT_RECORDER.ON_PLAY
			then
			    RO.COUNT_DOWN := RO.COUNT_DOWN - 1;
			end if;

			if RO.OBJECT.DELETE_PENDING then
			    if PREV /= null then
				PREV.NEXT := NEXT;
			    else
				RECEIVED_OBJECTS_LISTS(ROL_INDEX) := NEXT;
			    end if;
			    DEALLOCATE(THIS);
			else
			    PREV := THIS;
			end if;
		    end;
		    THIS := NEXT;
		end loop;
	    end loop;
	end;


        package TRANSMITTER_PACKETS is
            function GET_NEXT return SYSTEM.ADDRESS;
        end;

        package body TRANSMITTER_PACKETS is

	    type ACCESS_MESSAGE_TYPE is access MESSAGE_TYPE;
            PACKETS : array(0..10) of ACCESS_MESSAGE_TYPE
		    := (others => new MESSAGE_TYPE(NUMBER_OF_ITEMS_RANGE'last));

            NEXT    : NATURAL := 0;

            function GET_NEXT return SYSTEM.ADDRESS is
            begin
                NEXT := (NEXT+1) rem (PACKETS'last+1);
                return PACKETS(NEXT).all'address;
            end;

        end;


	procedure TRANSMIT_TO_ONE(
	    MESSAGE : MESSAGE_TYPE;
	    LE	    : ACCESS_LIST_OF_ACCESS_OUTPUT_CHANNEL_TYPE) is
	begin
	    TRANSCEIVER.TRANSMIT(LE.OC, MESSAGE);
	end; pragma INLINE(TRANSMIT_TO_ONE);


	procedure TRANSMIT_TO_ALL(MESSAGE : MESSAGE_TYPE) is
	    LE  : ACCESS_LIST_OF_ACCESS_OUTPUT_CHANNEL_TYPE
		:= LOC;
	begin
	    -- Make sure at least one on the list
	    if LE = null then return; end if;

	    -- Transmit to everyone on the list
	    loop
		TRANSMIT_TO_ONE(MESSAGE, LE);
		exit when LE.NEXT = null;
		LE := LE.NEXT;
	    end loop;

	    -- Return if only one item on the list
	    if LE = LOC then return; end if;

	    -- Rotate the list one entry, so we start at a new place next
	    -- time, so any errors slowly rotate around the list
	    LE.NEXT := LOC;
	    LE	    := LOC;
	    LOC     := LOC.NEXT;
	    LE.NEXT := null;

	end; pragma INLINE(TRANSMIT_TO_ALL);


	procedure TRANSMIT_UPDATES(
	    THIS_SIMULATORS_OBJECTS : OBJECTS.ACCESS_OBJECT_TYPE) is

	    use OBJECTS;

	    N : NATURAL := 0;
	    A : ACCESS_OBJECT_TYPE := THIS_SIMULATORS_OBJECTS;
	begin
	    -- Decide if anything to do
	    --
	    if	FLIGHT_RECORDER.STATE = FLIGHT_RECORDER.ON_RECORD
	    and FILTER_RECORDING.TO_FLIGHT_RECORDER
	    then
		FLIGHT_RECORDER.START_NEW_FRAME(
		    SCALAR_PHYSICS.SECONDS(
			ELAPSED_SINCE_LAST_TRANSMIT_TO_FLIGHT_RECORDER),
		    SOMETHING_INTERESTING_HAPPENED);

		SOMETHING_INTERESTING_HAPPENED := FALSE;

	    elsif not (HAS_MULTIPLAYERS and FILTER_RECORDING.TO_PARTNERS) then
		return;

	    end if;

	    -- Count the objects
	    --
	    while A /= null loop N := N+1; A := A.NEXT; end loop;

	    -- Create the messages and send them
	    --
	    A := THIS_SIMULATORS_OBJECTS;
	    while N /= 0 loop
		declare
		    M : NATURAL := N;
		begin
		    if M > MESSAGE_MANAGER.NUMBER_OF_ITEMS_RANGE'last then
			M := MESSAGE_MANAGER.NUMBER_OF_ITEMS_RANGE'last;
		    end if;

		    declare
			MESSAGE : MESSAGE_TYPE(M);
			for MESSAGE use at TRANSMITTER_PACKETS.GET_NEXT;
		    begin
			MESSAGE.TRANSMIT_TIME := 0.0;
			M := 0;
			while M < MESSAGE.NUMBER_OF_ITEMS loop
			    M := M + 1;
			    declare
				O : OBJECT_TYPE renames A.all;
				I : MESSAGE_ITEM_TYPE renames MESSAGE.ITEMS(M);

				ORIENTATION : COMPRESSED_ORIENTATION_MANAGER.
				    COMPRESSED_ORIENTATION_TYPE;

			    begin
				COMPRESS(O.ORIENTATION, ORIENTATION);

				I := (REASON =>	OBJECT_HERE,
				    SEQUENCE_NUMBER => O.SEQUENCE_NUMBER,
				    OBJECT_INFO     => O.OBJECT_INFO,
				    CLASS	    => O.CLASS,
				    LOCATION	    => O.LOCATION,
				    ORIENTATION     => ORIENTATION,
				    APPEARANCE_INFO => O.APPEARANCE_INFO,
				    CLASS_INFO	    => O.CLASS_INFO,
				    SUBCLASS	    => O.SUBCLASS);

				A := O.NEXT;
			    end;
			end loop;

			if FLIGHT_RECORDER.STATE = FLIGHT_RECORDER.ON_RECORD
			and FILTER_RECORDING.TO_FLIGHT_RECORDER
			then
			    FLIGHT_RECORDER.RECORD_MESSAGE(
				MESSAGE,
				FLIGHT_RECORDER.THIS_SIMULATOR_REMOTE_NUMBER);
			end if;

			if HAS_MULTIPLAYERS
			and FILTER_RECORDING.TO_PARTNERS
			then
			    TRANSMIT_TO_ALL(MESSAGE);
			end if;

		    end;
		    N := N - M;
		end;
	    end loop;

	    if REQUESTED_TO_QUIT then
		REQUESTED_TO_QUIT := FALSE;
		INSTRUMENTS.SET(INSTRUMENTS.MESSAGES, "qsnt");
		if HAS_MULTIPLAYERS then
		    declare
			MESSAGE : MESSAGE_TYPE(1);
		    begin
			MESSAGE.ITEMS(1) := (REASON=>TIME_TO_QUIT);
			TRANSMIT_TO_ALL(MESSAGE);
		    end;
		end if;
	    end if;
	end;


	procedure TRANSMIT_DELETE_PENDING(OBJECT : OBJECTS.ACCESS_OBJECT_TYPE) is

	    MESSAGE : MESSAGE_TYPE(1);
	    for MESSAGE use at TRANSMITTER_PACKETS.GET_NEXT;

	    I	: MESSAGE_ITEM_TYPE renames MESSAGE.ITEMS(1);

	    ARO : ACCESS_RECEIVED_OBJECT_TYPE;
	begin

SCAN :	    for ROL_INDEX in RECEIVED_OBJECTS_LISTS'range loop
		ARO := RECEIVED_OBJECTS_LISTS(ROL_INDEX);
		while ARO /= null loop
		    declare
			RO : RECEIVED_OBJECT_TYPE renames ARO.all;
		    begin
			exit SCAN when RO.OBJECT = OBJECT;
			ARO := RO.NEXT;
		    end;
		end loop;
	    end loop SCAN;

	    if ARO = null then
		TEXT_IO.PUT_LINE("Hit a ghost!");
		return;
	    end if;

	    MESSAGE.TRANSMIT_TIME := 0.0;
	    I := (REASON	    => HIT_BY_OBJECT,
		HIT_SEQUENCE_NUMBER => ARO.REMOTE_SEQUENCE_NUMBER,
		HIT_OBJECT_INFO     => ARO.REMOTE_OBJECT_INFO,
		KILLED		    => TRUE);

	    begin
		if HAS_MULTIPLAYERS then
		    declare
			LE  : ACCESS_LIST_OF_ACCESS_OUTPUT_CHANNEL_TYPE := LOC;
		    begin
			while LE /= null loop
			    if LE.REMOTE_NUMBER = ARO.REMOTE_NUMBER then
				TRANSMIT_TO_ONE(MESSAGE, LE);
				exit;
			    end if;
			    LE := LE.NEXT;
			end loop;
		    end;
		end if;
		SOMETHING_INTERESTING_HAPPENED := TRUE;
		SCORE.KILLED(Natural(ARO.REMOTE_NUMBER), ARO.HIT_AT_LEAST_ONCE);
		ARO.HIT_AT_LEAST_ONCE := TRUE;
	    end;

	end;


    begin
	if FCTM_ETHERNET_PARTNER.TRANSLATION /= "" then
	    HAS_MULTIPLAYERS := TRUE;
	    IC := OPEN;

	    declare
		S : STRING renames FCTM_ETHERNET_PARTNER.TRANSLATION;
		F : INTEGER := S'first;
		L : INTEGER := S'first;
	    begin
		while F <= S'last loop

		    L := F;
		    while L <= S'last and then S(L) /= ',' loop
			L := L+1;
		    end loop;

		    declare
			subtype EA_SUBTYPE is ETHERNET_ADDRESS_TYPE(1..L-F);
			EA  : constant EA_SUBTYPE := EA_SUBTYPE(S(F..L-1));
			REMOTE_NUMBER : REMOTE_NUMBER_TYPE;
			WAS_DEFINED   : BOOLEAN;
		    begin
			TO_REMOTE_NUMBER_TYPE(EA, TRUE, REMOTE_NUMBER,
			    WAS_DEFINED);
			LOC :=
			    new LIST_OF_ACCESS_OUTPUT_CHANNEL_TYPE'(
				NEXT		=> LOC,
				OC		=> CREATE(EA),
				REMOTE_NUMBER	=> REMOTE_NUMBER
				);
		    end;

		    F := L+1;
		end loop;
	    end;

	    TRANSCEIVER.START_RECEIVING(IC);
	end if;
    end; pragma SUPPRESS_ALL;
