--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************



with CLOSEST_APPROACH, COLLISION_DUMP, MAIN_SIMULATION_COLLISION_CHECK_CONTEXT,
    SCORE;

with SCALAR_PHYSICS, TEXT_IO, FLOAT_TEXT_IO;
use  SCALAR_PHYSICS;

pragma ELABORATE(SCALAR_PHYSICS);

separate(MAIN_SIMULATION.OBJECT_SYNC)
    procedure COLLISION_CHECK is
	A1,A2 : ACCESS_OBJECT_TYPE;

	REDUCE_WING_SIZE_FACTOR : METRES;

	procedure LOAD_INFO(
	    O			    : OBJECT_TYPE;
	    EXTRA_RADIUS_INDEX	    : INTEGER;

	    R			    : out METRES;
	    OLD_LOCATION, LOCATION  : out OBJECT_LOCATION
	    )
	is

	    EXTRA_RADIUS    : EXTRA_RADIUS_TYPE
				renames O.EXTRA_RADII(EXTRA_RADIUS_INDEX);
	    ORIGIN_I,
	    ORIGIN_J,
	    ORIGIN_K	    : OBJECT_LOCATION_COORDINATE;

	begin
	    R := EXTRA_RADIUS.RADIUS;
	    if EXTRA_RADIUS.RADIUS = 0.0 then return; end if;

	    if EXTRA_RADIUS_INDEX<=2
	    and then O.CLASS = AEROPLANE
	    then
		R := EXTRA_RADIUS.RADIUS*REDUCE_WING_SIZE_FACTOR;
	    end if;

	    ORIGIN_I := OBJECT_LOCATION_COORDINATE(METRES'(
		O.ORIENTATION.I.I * EXTRA_RADIUS.ORIGIN.I +
		O.ORIENTATION.J.I * EXTRA_RADIUS.ORIGIN.J +
		O.ORIENTATION.K.I * EXTRA_RADIUS.ORIGIN.K));
	    ORIGIN_J := OBJECT_LOCATION_COORDINATE(METRES'(
		O.ORIENTATION.I.J * EXTRA_RADIUS.ORIGIN.I +
		O.ORIENTATION.J.J * EXTRA_RADIUS.ORIGIN.J +
		O.ORIENTATION.K.J * EXTRA_RADIUS.ORIGIN.K));

	    ORIGIN_K := OBJECT_LOCATION_COORDINATE(METRES'(
		O.ORIENTATION.I.K * EXTRA_RADIUS.ORIGIN.I +
		O.ORIENTATION.J.K * EXTRA_RADIUS.ORIGIN.J +
		O.ORIENTATION.K.K * EXTRA_RADIUS.ORIGIN.K));

	    OLD_LOCATION.I := O.OLD_LOCATION.I + ORIGIN_I;
	    OLD_LOCATION.J := O.OLD_LOCATION.J + ORIGIN_J;
	    OLD_LOCATION.K := O.OLD_LOCATION.K + ORIGIN_K;

	    LOCATION.I     := O.LOCATION.I     + ORIGIN_I;
	    LOCATION.J     := O.LOCATION.J     + ORIGIN_J;
	    LOCATION.K     := O.LOCATION.K     + ORIGIN_K;

	end;
	    pragma INLINE(LOAD_INFO);

	function DETAILED_CHECK(O1, O2 : OBJECT_TYPE) return BOOLEAN is
	begin
	    -- This hack reduces the sizes of the wing spheres on the aircraft,
	    -- to reduce the likelyhood of a head-on hit.  Without it, aircraft
	    -- with big wings (eg: F-4) are severely penalized during head-on's.
	    --
	    if O1.CLASS = AEROPLANE and O2.CLASS = BULLETS
	    then
		REDUCE_WING_SIZE_FACTOR := abs(
		    WORLD_PHYSICS."&"(O1.ORIENTATION.K,O2.ORIENTATION.J));

		if MAIN_SIMULATION_COLLISION_CHECK_CONTEXT.
		    DUMP_REDUCE_WING_SIZE_FACTOR
		then
		    TEXT_IO.PUT("REDUCE_WING_SIZE_FACTOR := ");
		    FLOAT_TEXT_IO.PUT(FLOAT(REDUCE_WING_SIZE_FACTOR));
		    TEXT_IO.NEW_LINE;
		end if;

	    elsif O1.CLASS = BULLETS and O2.CLASS = AEROPLANE
	    then
		REDUCE_WING_SIZE_FACTOR := abs(
		    WORLD_PHYSICS."&"(O1.ORIENTATION.J,O2.ORIENTATION.K));

		if MAIN_SIMULATION_COLLISION_CHECK_CONTEXT.
		    DUMP_REDUCE_WING_SIZE_FACTOR
		then
		    TEXT_IO.PUT("REDUCE_WING_SIZE_FACTOR := ");
		    FLOAT_TEXT_IO.PUT(FLOAT(REDUCE_WING_SIZE_FACTOR));
		    TEXT_IO.NEW_LINE;
		end if;

	    else
		REDUCE_WING_SIZE_FACTOR := 1.0;
	    end if;

	    for I1 in O1.EXTRA_RADII'range loop
		declare
		    R1 : METRES;
		    O1_OLD_LOCATION, O1_LOCATION : OBJECT_LOCATION;
		begin
		    LOAD_INFO(
			O1, I1,
			R1, O1_OLD_LOCATION, O1_LOCATION);

		    exit when R1 = 0.0;

		    for I2 in O2.EXTRA_RADII'range loop
			declare
			    R2 : METRES;
			    O2_OLD_LOCATION, O2_LOCATION : OBJECT_LOCATION;
			begin
			    LOAD_INFO(
				O2, I2,
				R2, O2_OLD_LOCATION, O2_LOCATION);

			    exit when R2 = 0.0;

			    if CLOSEST_APPROACH(
				    O1_OLD_LOCATION,
				    O1_LOCATION,
				    O2_OLD_LOCATION,
				    O2_LOCATION)
				<
				SCALE_TYPE(R1+R2)**2
			    then
				return TRUE;
			    end if;
			end;
		    end loop;

		end;
	    end loop;

	    return FALSE;
	end;

    begin
	A1 := MAINTAINER_TO_ACCESS_OBJECT(THIS_SIMULATOR);
	while A1 /= null loop
	    declare
		O1 : OBJECT_TYPE renames A1.all;
	    begin
		for I in THIS_SIMULATOR..ANOTHER_SIMULATOR loop
		    A2 := MAINTAINER_TO_ACCESS_OBJECT(I);
		    while A2 /= null loop
			declare
			    O2 : OBJECT_TYPE renames A2.all;
			begin
			    exit when O2.CLASS not in TARGET_CLASS_SUBTYPE;

if A1 = A2
or A1.CLASS = MAGIC_CARPET
or A2.CLASS = MAGIC_CARPET
--
-- the following is a tentative optimization to stop bullets being checked
-- against the shooting plane.
--
or ((A2 = CONTROLLED_OBJECT.OBJECT_TO_BE_CONTROLLED) and then
    (not MAIN_SIMULATION_COLLISION_CHECK_CONTEXT.CAN_HIT_CONTROLLED_OBJECT))
then
    null;

elsif CLOSEST_APPROACH(
	O1.OLD_LOCATION,
	O1.LOCATION,
	O2.OLD_LOCATION,
	O2.LOCATION)
    <
    SCALE_TYPE(O1.RADIUS+O2.RADIUS)**2
and then
    DETAILED_CHECK(O1, O2)
then

    if COLLISION_DUMP.ENABLED then
	COLLISION_DUMP.DUMP(A1.all, A2.all);
    end if;

    if O1.CLASS in TARGET_CLASS_SUBTYPE then
	SCORE.OTHER_DEATH("collision...");
    end if;
    SET_DELETE_PENDING(A1);

    case O2.MAINTAINER is   
	when NONE_NEEDED	=>
	    raise PROGRAM_ERROR;
	when THIS_SIMULATOR	=>
	    SET_DELETE_PENDING(A2);
	when ANOTHER_SIMULATOR	=>
	    MULTIPLAYER_SUPPORT.TRANSMIT_DELETE_PENDING(A2);
    end case;
end if;

			    A2 := O2.NEXT;
			end;
		    end loop;
		end loop;
		A1 := O1.NEXT;
	    end;
	end loop;
    end;
