--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with CALENDAR, OBJECTS, SCALAR_PHYSICS, WORLD_PHYSICS, INFO_MANAGER;
use  CALENDAR, OBJECTS;
package MAIN_SIMULATION is

    ELAPSED_SINCE_LAST_ITERATION : SCALAR_PHYSICS.SECONDS;

    TIME_OF_LAST_ITERATION,
    TIME_OF_THIS_ITERATION : TIME;

    MAINTAINER_TO_ACCESS_OBJECT 	: MAINTAINER_TO_ACCESS_OBJECT_TYPE;
    MAINTAINER_TO_ACCESS_OBJECT_TAIL	: MAINTAINER_TO_ACCESS_OBJECT_TYPE;

    -- The following must only be called from inside the OBJECT_SYNC
    --
    procedure ADD_ONE_OBJECT    (OBJECT : OBJECTS.ACCESS_OBJECT_TYPE);
    procedure REMOVE_ONE_OBJECT (OBJECT : OBJECTS.ACCESS_OBJECT_TYPE);
    procedure SET_DELETE_PENDING(OBJECT : OBJECTS.ACCESS_OBJECT_TYPE);

    -- Task Object that executes the main simulation loop
    --
    task OBJECT_SYNC is
	entry START(STATIONARY_OBJECTS : OBJECTS.ACCESS_OBJECT_TYPE);

	entry ADD_OBJECT    (
	    CLASS	    : OBJECTS.CLASS_TYPE;
	    SUBCLASS	    : INFO_MANAGER.SUBCLASS_TYPE;
	    LOCATION	    : OBJECTS.OBJECT_LOCATION;
	    ORIENTATION     : WORLD_PHYSICS.POSITION_BASIS;
	    VELOCITY	    : WORLD_PHYSICS.VELOCITY;
	    MAINTAINER	    : OBJECTS.MAINTAINER_TYPE;
	    CONTROLLED	    : BOOLEAN := FALSE);

	entry REMOVE_OBJECT (OBJECT : OBJECTS.ACCESS_OBJECT_TYPE);

--	entry INFO_FROM_ANOTHER_SIMULATOR(####);
--	entry REQUEST_TO_SEND_TO_ANOTHER_SIMULATOR(####);

	entry REQUEST_TO_GENERATE_NEXT_VIEW;
	entry SELECT_NEW_CONTROLLED_OBJECT;
    end;

    procedure REQUEST_TO_SELECT_NEW_CONTROLLED_OBJECT;
    procedure REQUEST_TO_QUIT;

end;
