--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    GENERATE_NEXT_VIEW,  MOVE_THIS_SIMULATORS_OBJECTS,
    GET_CPU_TIME, TEXT_IO, FLOAT_TEXT_IO,
    LOGICAL_TO_BOOLEAN ,LOGICAL_TO_FLOAT,
    CALENDAR;
use
    CALENDAR;

pragma ELABORATE(
    TEXT_IO, FLOAT_TEXT_IO,
    LOGICAL_TO_BOOLEAN, LOGICAL_TO_FLOAT,
    CALENDAR);

package body MAIN_SIMULATION is

    MINIMUM_DELAY_BETWEEN_ITERATIONS : constant DURATION
	:= DURATION(LOGICAL_TO_FLOAT(
	    "FCTM_MINIMUM_DELAY_BETWEEN_ITERATIONS",0.005));

    MINIMUM_DELAY_BETWEEN_TRANSMIT_TO_PARTNERS : constant DURATION
	:= DURATION(LOGICAL_TO_FLOAT(
	    "FCTM_MINIMUM_DELAY_BETWEEN_TRANSMIT_TO_PARTNERS",0.004));

    MINIMUM_DELAY_BETWEEN_TRANSMIT_TO_FLIGHT_RECORDER : constant DURATION
	:= DURATION(LOGICAL_TO_FLOAT(
	    "FCTM_MINIMUM_DELAY_BETWEEN_TRANSMIT_TO_FLIGHT_RECORDER",0.08));

    REQUESTED_TO_SELECT_NEW_CONTROLLED_OBJECT : BOOLEAN := FALSE;
	pragma SHARED(REQUESTED_TO_SELECT_NEW_CONTROLLED_OBJECT);

    REQUESTED_TO_QUIT : BOOLEAN := FALSE;
	pragma SHARED(REQUESTED_TO_QUIT);

    DELETE_PENDING_LIST : ACCESS_OBJECT_TYPE;

    SHOW_TIMING_INFO : constant BOOLEAN
	:= LOGICAL_TO_BOOLEAN("FCTM_SHOW_TIMING_INFO", FALSE);


    procedure REQUEST_TO_SELECT_NEW_CONTROLLED_OBJECT is
    begin
	REQUESTED_TO_SELECT_NEW_CONTROLLED_OBJECT := TRUE;
    end;

    procedure REQUEST_TO_QUIT is
    begin
	REQUESTED_TO_QUIT := TRUE;
    end;


    -- The following must only be called from inside the OBJECT_SYNC
    --
    procedure ADD_ONE_OBJECT(OBJECT : OBJECTS.ACCESS_OBJECT_TYPE) is

	O : OBJECTS.OBJECT_TYPE renames OBJECT.all;

	LIST_HEAD : ACCESS_OBJECT_TYPE renames
	    MAINTAINER_TO_ACCESS_OBJECT(O.MAINTAINER);
	LIST_TAIL : ACCESS_OBJECT_TYPE renames
	    MAINTAINER_TO_ACCESS_OBJECT_TAIL(O.MAINTAINER);

    begin
	-- Put targets at the head of the list, others at the end
	-- This cheapens collision checking.
	--
	if O.CLASS in OBJECTS.TARGET_CLASS_SUBTYPE then
	    if LIST_HEAD /= null then
		LIST_HEAD.PREV := OBJECT;
	    else
		LIST_TAIL := OBJECT;
	    end if;
	    O.PREV := null;
	    O.NEXT := LIST_HEAD;
	    LIST_HEAD	:= OBJECT;
	else
	    if LIST_TAIL /= null then
		LIST_TAIL.NEXT := OBJECT;
	    else
		LIST_HEAD := OBJECT;
	    end if;
	    O.NEXT := null;
	    O.PREV := LIST_TAIL;
	    LIST_TAIL	:= OBJECT;
	end if;
    end;


    procedure REMOVE_ONE_OBJECT(OBJECT : OBJECTS.ACCESS_OBJECT_TYPE) is

	O : OBJECTS.OBJECT_TYPE renames OBJECT.all;

	LIST_HEAD : ACCESS_OBJECT_TYPE renames
	    MAINTAINER_TO_ACCESS_OBJECT(O.MAINTAINER);
	LIST_TAIL : ACCESS_OBJECT_TYPE renames
	    MAINTAINER_TO_ACCESS_OBJECT_TAIL(O.MAINTAINER);

    begin
	if O.PREV /= null then
	    O.PREV.NEXT := O.NEXT;
	else
	    LIST_HEAD := O.NEXT;
	end if;
	if O.NEXT /= null then
	    O.NEXT.PREV := O.PREV;
	else
	    LIST_TAIL := O.PREV;
	end if;
    end;


    procedure SET_DELETE_PENDING(OBJECT : OBJECTS.ACCESS_OBJECT_TYPE) is
	O : OBJECTS.OBJECT_TYPE renames OBJECT.all;
    begin
	if not O.DELETE_PENDING then
	    O.DELETE_PENDING	:= TRUE;
	    O.DELETE_NEXT	:= DELETE_PENDING_LIST;
	    DELETE_PENDING_LIST	:= OBJECT;
	end if;
    end;


    task body OBJECT_SYNC is separate;

end;
