--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with TEXT_IO, CHARACTER_UTILITIES;
package body LOGICAL_TO_STRING_MANAGER is

    type PAIR_TYPE(LEN_NAME, LEN_VALUE : NATURAL);
    type ACCESS_PAIR_TYPE is access PAIR_TYPE;
    type PAIR_TYPE(LEN_NAME, LEN_VALUE : NATURAL) is
	record
	    NEXT    : ACCESS_PAIR_TYPE;
	    NAME    : STRING(1..LEN_NAME);
	    VALUE   : STRING(1..LEN_VALUE);
	end record;

    PAIRS : ACCESS_PAIR_TYPE := null;

    function LOGICAL_TO_STRING(
	S	: STRING;
	DEFAULT : STRING)
	return STRING is

	P : ACCESS_PAIR_TYPE := PAIRS;

    begin
	while P /= null loop
	    if CHARACTER_UTILITIES.SOMEWHAT_EQUAL(P.NAME, S) then
		return P.VALUE;
	    end if;
	    P := P.NEXT;
	end loop;
	return DEFAULT;
    end;

begin
    declare
	use TEXT_IO;

	FILE	: FILE_TYPE;

	ITEM	: STRING(1..1024);
	NAME_FIRST, NAME_LAST, VALUE_FIRST, VALUE_LAST,
	LAST	: NATURAL range 0..ITEM'last;

	P	: ACCESS_PAIR_TYPE;

	procedure SCAN(
	    FROM	: NATURAL;
	    FOR_SPACE	: BOOLEAN;
	    FOUND	: out NATURAL) is
	begin
	    for I in FROM..LAST loop
		if (ITEM(I) = ' ' or
		    ITEM(I) = ASCII.HT) = FOR_SPACE then
		    if FOR_SPACE then
			FOUND := I-1;
		    else
			FOUND := I;
		    end if;
		    return;
		end if;
	    end loop;
	    if FOR_SPACE then
		FOUND := LAST;
	    else
		FOUND := LAST+1;
	    end if;
	end;

    begin
	OPEN (
	    FILE => FILE,
	    MODE => IN_FILE,
	    NAME => ".fctm");
	while not END_OF_FILE(FILE) loop
	    GET_LINE(FILE, ITEM, LAST);

	    SCAN(1, FALSE, NAME_FIRST);
	    if ITEM(NAME_FIRST) /= '#'
	    and NAME_FIRST <= LAST
	    then
		SCAN(NAME_FIRST, TRUE,  NAME_LAST);
		SCAN(NAME_LAST+1,FALSE, VALUE_FIRST);

		-- Instead of this ... SCAN(VALUE_FIRST,TRUE,  VALUE_LAST);
		-- this allows internal spacing in the value.
		--
		for I in reverse VALUE_FIRST .. LAST loop
		    if ITEM(I) /= ' ' and ITEM(I) /= ASCII.HT then
			VALUE_LAST := I;
			exit;
		    end if;
		end loop;

		P := new PAIR_TYPE(
			    LEN_NAME	=> NAME_LAST+1-NAME_FIRST,
			    LEN_VALUE	=> VALUE_LAST+1-VALUE_FIRST);

		P.NEXT := PAIRS;
		P.NAME := ITEM(NAME_FIRST ..NAME_LAST);
		P.VALUE:= ITEM(VALUE_FIRST..VALUE_LAST);

		PAIRS := P;

	    end if;
	end loop;
    exception
	when NAME_ERROR => null;
    end;
end;
