--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with SYSTEM_INTERFACE, LOGICAL_TO_STRING;

function LOGICAL_TO_FLOAT(
    S	    : STRING;
    DEFAULT : SYSTEM_INTERFACE.LONGEST_FLOAT)
    return SYSTEM_INTERFACE.LONGEST_FLOAT is

    TRNLNM  : constant STRING := LOGICAL_TO_STRING(S, "");

    RESULT  : SYSTEM_INTERFACE.LONGEST_FLOAT := DEFAULT;

begin

    if TRNLNM'length > 0 then
	declare
	    LAST : NATURAL;
	begin
	    SYSTEM_INTERFACE.LONGEST_FLOAT_TEXT_IO.GET(
		FROM => TRNLNM,
		ITEM => RESULT,
		LAST => LAST);
	exception
	    when others => null;
	end;
    end if;

    return RESULT;
end;
