--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with SCALAR_PHYSICS, STANDARD_ATMOSPHERE, TRIG;
use  SCALAR_PHYSICS, STANDARD_ATMOSPHERE;
package LIFT_DRAG_CURVE_MANAGER is

    type ACCESS_LIFT_AND_DRAG_CURVE_TYPE is private;

    subtype DRAG_SUBTYPE is SCALE_TYPE;
    subtype LIFT_SUBTYPE is SCALE_TYPE;

    subtype AEROLON_SUBTYPE   is SCALE_TYPE range -1.0 .. 1.0;
    subtype HIGH_LIFT_SUBTYPE is SCALE_TYPE range  0.0 .. 1.0;

    NO_SUCH_LIFT_DRAG_CURVE : exception;

    type LIFT_DRAG_INPUTS is
	record
	    LIFT_DRAG_CURVE : ACCESS_LIFT_AND_DRAG_CURVE_TYPE;
	    EXTRA_ZERO_DRAG : SCALE_TYPE;
	    MACH	    : MACH_TYPE;
	    AEROLONS	    : AEROLON_SUBTYPE;
	    HIGH_LIFT	    : HIGH_LIFT_SUBTYPE;

	    CL_ALPHA	    : SCALE_TYPE;
	    CL_MAX	    : SCALE_TYPE;
	    CD_PER_CL2	    : SCALE_TYPE;

	    ANGLE_OF_ATTACK : TRIG.RADIANS;
	end record;

    type LIFT_DRAG_OUTPUTS is
	record
	    CL		    : LIFT_SUBTYPE;
	    CD		    : DRAG_SUBTYPE;
	    AOA_MAX	    : TRIG.RADIANS;
	end record;

    function GET_LIFT_DRAG_CURVE(
	NAME : STRING)
	return ACCESS_LIFT_AND_DRAG_CURVE_TYPE;

    procedure COMPUTE_CL_ALPHAS_AND_CD_PER_CL2(
	ASPECT_RATIO	    : SCALE_TYPE;
	SIN_SWEEP_ANGLE     : SCALE_TYPE;
	COS_SWEEP_ANGLE     : SCALE_TYPE;
	PARTIAL_LAMBDA_50   : SCALE_TYPE;
	MACH		    : STANDARD_ATMOSPHERE.MACH_TYPE;
	ORV_I, ORV_J	    : METRES_PER_SECOND;

	CL_ALPHA_LEFT	    : out SCALE_TYPE;
	CL_ALPHA_RIGHT	    : out SCALE_TYPE;
	CL_MAX		    : out SCALE_TYPE;
	CD_PER_CL2	    : out SCALE_TYPE);

    procedure GET_LIFT_AND_DRAG(
	INPUTS	: in  LIFT_DRAG_INPUTS;
	OUTPUTS	: out LIFT_DRAG_OUTPUTS);

private
    type LIFT_AND_DRAG_CURVE_TYPE;
    type ACCESS_LIFT_AND_DRAG_CURVE_TYPE is access LIFT_AND_DRAG_CURVE_TYPE;

end;
