--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


package INSTRUMENTS is

    type VALUE_TYPE is digits 6;

    type INSTRUMENTS_TYPE is
	(ALT, SPEED, ACCEL, AoA, AoY, CLIMB, MACH, FUEL, MISSILE_GUIDANCE,
	 KILLS, DEATHS, MISSILES, BULLETS,
	 MESSAGES);

    subtype VALUE_INSTRUMENTS_TYPE is
	INSTRUMENTS_TYPE range ALT..MISSILE_GUIDANCE;

    subtype NATURAL_INSTRUMENTS_TYPE is
	INSTRUMENTS_TYPE range KILLS..BULLETS;

    subtype TEXT_INSTRUMENTS_TYPE is
	INSTRUMENTS_TYPE range MESSAGES..MESSAGES;

    procedure SET(
	INSTRUMENT  : VALUE_INSTRUMENTS_TYPE;
	VALUE	    : VALUE_TYPE);

    procedure SET(
	INSTRUMENT  : NATURAL_INSTRUMENTS_TYPE;
	VALUE	    : NATURAL);

    procedure SET(
	INSTRUMENT  : TEXT_INSTRUMENTS_TYPE;
	VALUE	    : STRING);

    INSTRUMENT_NOT_SET : exception;

    function GET(
	    INSTRUMENT  : VALUE_INSTRUMENTS_TYPE)
	    return VALUE_TYPE;
	    
    function GET(
	    INSTRUMENT  : NATURAL_INSTRUMENTS_TYPE)
	    return NATURAL;

    function GET(
	    INSTRUMENT  : TEXT_INSTRUMENTS_TYPE)
	    return STRING;

    generic
	with procedure GET(
	    INSTRUMENT  : VALUE_INSTRUMENTS_TYPE;
	    VALUE	: VALUE_TYPE);
	with procedure GET(
	    INSTRUMENT  : NATURAL_INSTRUMENTS_TYPE;
	    VALUE	: NATURAL);
	with procedure GET(
	    INSTRUMENT  : NATURAL_INSTRUMENTS_TYPE;
	    VALUE	: STRING;
	    CHANGED_SINCE_LAST_SCAN : BOOLEAN);
    procedure SCAN;

    pragma INLINE(SET, GET);
end;
