--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    UNCHECKED_DEALLOCATION;

pragma ELABORATE(
    UNCHECKED_DEALLOCATION);

package body INSTRUMENTS is

    type ACCESS_STRING is access STRING;
    procedure DEALLOCATE is new UNCHECKED_DEALLOCATION(STRING, ACCESS_STRING);

    VALUE_INSTRUMENTS_SET   : array(VALUE_INSTRUMENTS_TYPE) of BOOLEAN
			    := (others => FALSE);
    VALUE_INSTRUMENTS	    : array(VALUE_INSTRUMENTS_TYPE) of VALUE_TYPE;

    NATURAL_INSTRUMENTS_SET : array(NATURAL_INSTRUMENTS_TYPE) of BOOLEAN
			    := (others => FALSE);
    NATURAL_INSTRUMENTS	    : array(NATURAL_INSTRUMENTS_TYPE) of NATURAL;

    TEXT_INSTRUMENTS_SET    : array(TEXT_INSTRUMENTS_TYPE) of BOOLEAN
			    := (others => FALSE);
    TEXT_INSTRUMENTS_CHANGED: array(TEXT_INSTRUMENTS_TYPE) of BOOLEAN
			    := (others => FALSE);
    TEXT_INSTRUMENTS	    : array(TEXT_INSTRUMENTS_TYPE) of ACCESS_STRING;

    procedure SET(
	INSTRUMENT  : VALUE_INSTRUMENTS_TYPE;
	VALUE	    : VALUE_TYPE)
    is
    begin
	VALUE_INSTRUMENTS(INSTRUMENT) := VALUE;
	VALUE_INSTRUMENTS_SET(INSTRUMENT) := TRUE;
    end;

    procedure SET(
	INSTRUMENT  : NATURAL_INSTRUMENTS_TYPE;
	VALUE	    : NATURAL)
    is
    begin
	NATURAL_INSTRUMENTS(INSTRUMENT) := VALUE;
	NATURAL_INSTRUMENTS_SET(INSTRUMENT) := TRUE;
    end;

    procedure SET(
	INSTRUMENT  : TEXT_INSTRUMENTS_TYPE;
	VALUE	    : STRING) is
    begin
	DEALLOCATE(TEXT_INSTRUMENTS(INSTRUMENT));
	TEXT_INSTRUMENTS(INSTRUMENT) := new STRING'(VALUE);
	TEXT_INSTRUMENTS_CHANGED(INSTRUMENT) := TRUE;
	TEXT_INSTRUMENTS_SET(INSTRUMENT) := TRUE;
    end;

    function GET(
	    INSTRUMENT  : VALUE_INSTRUMENTS_TYPE)
	    return VALUE_TYPE is
    begin
	if VALUE_INSTRUMENTS_SET(INSTRUMENT) then
	    return VALUE_INSTRUMENTS(INSTRUMENT);
	end if;
	raise INSTRUMENT_NOT_SET;
    end;
	    
    function GET(
	    INSTRUMENT  : NATURAL_INSTRUMENTS_TYPE)
	    return NATURAL is
    begin
	if NATURAL_INSTRUMENTS_SET(INSTRUMENT) then
	    return NATURAL_INSTRUMENTS(INSTRUMENT);
	end if;
	raise INSTRUMENT_NOT_SET;
    end;

    function GET(
	    INSTRUMENT  : TEXT_INSTRUMENTS_TYPE)
	    return STRING is
    begin
	if TEXT_INSTRUMENTS_SET(INSTRUMENT) then
	    return TEXT_INSTRUMENTS(INSTRUMENT).all;
	end if;
	raise INSTRUMENT_NOT_SET;
    end;

    procedure SCAN is
    begin
	for I in VALUE_INSTRUMENTS_TYPE loop
	    if VALUE_INSTRUMENTS_SET(I) then
		GET(I, VALUE_INSTRUMENTS(I));
	    end if;
	end loop;
	for I in NATURAL_INSTRUMENTS_TYPE loop
	    if NATURAL_INSTRUMENTS_SET(I) then
		GET(I, NATURAL_INSTRUMENTS(I));
	    end if;
	end loop;
	for I in TEXT_INSTRUMENTS_TYPE loop
	    if TEXT_INSTRUMENTS_SET(I) then
		GET(I, TEXT_INSTRUMENTS(I).all, TEXT_INSTRUMENTS_CHANGED(I));
	    end if;
	end loop;
    end;

end;
