--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


separate(INSTRUMENT_PANEL)
    procedure UPDATE is

	procedure GET(
	    INSTRUMENT  : VALUE_INSTRUMENTS_TYPE;
	    THE_VALUE	: VALUE_TYPE)
	is
	    FEET_per_METRE : constant VALUE_TYPE
		:= (39.37/12.0); -- inches_per_metre / inches_per_foot
	    MILES_PER_HOUR_per_METRES_PER_SECOND : constant VALUE_TYPE
		:= (3600.0*FEET_per_METRE/5280.0);

	    KNOTS_per_METRES_PER_SECOND : constant VALUE_TYPE
		:= MILES_PER_HOUR_per_METRES_PER_SECOND * 0.87;

	    VALUE : VALUE_TYPE := THE_VALUE;

	begin
	    case INSTRUMENT is
		when ALT =>
		    VALUE := VALUE*FEET_per_METRE;

		when SPEED =>
		    if SPEED_IN_KNOTS then
			VALUE := VALUE*KNOTS_per_METRES_PER_SECOND;
		    else
			VALUE := VALUE*MILES_PER_HOUR_per_METRES_PER_SECOND;
		    end if;
		    if SPEED_IS_CAS then
			declare
			    use SCALAR_PHYSICS;
			    ALT_MAX_0 : METRES
				:= METRES(VALUE_TYPE'(INSTRUMENTS.GET(ALT)));
			begin
			    if ALT_MAX_0 < 0.0 then
				ALT_MAX_0 := 0.0;
			    end if;
			    VALUE :=
				VALUE*VALUE_TYPE(
				    STANDARD_ATMOSPHERE.TO_SQRT_DENSITY_RATIO(
					ALT_MAX_0));
			end;
		    end if;

		when FUEL =>
		    VALUE := VALUE*10.0;

		when others =>
		    null;

	    end case;

	    case INSTRUMENT is
		when ALT|SPEED|ACCEL|FUEL|MISSILE_GUIDANCE =>
		    SET_NUMERIC(METERS(INSTRUMENT),
			INSTRUMENT_VALUE_TYPE(VALUE));

		when AoA =>
		    null;

		when AoY =>
		    null;

		when CLIMB =>
		    null;

		when MACH =>
		    declare
			MACH_TEXT : STRING(1..3);
			MACH_INT  : INTEGER := INTEGER(VALUE*100.0);
		    begin
			if MACH_INT > 999 then MACH_INT := 999; end if;

			for I in reverse MACH_TEXT'range loop
			    MACH_TEXT(I) :=
				CHARACTER'val(CHARACTER'pos('0')+MACH_INT rem 10);
			    MACH_INT := MACH_INT/10;
			end loop;

			SET_TEXT(METERS(INSTRUMENTS.MACH), MACH_TEXT);
		    end;

	    end case;
	end;

	procedure GET(
	    INSTRUMENT  : NATURAL_INSTRUMENTS_TYPE;
	    VALUE	: NATURAL)
	is
	begin
	    case INSTRUMENT is
		when KILLS =>
		    null;

		when DEATHS =>
		    null;

		when MISSILES =>
		    if VALUE /= OLD_MISSILE_INT then
			OLD_MISSILE_INT := VALUE;
			declare
			    MISS_TEXT : STRING(1..6) := "   123";
			    MISS_INT  : NATURAL := VALUE;
			begin
			    for I in reverse 4..6 loop
				MISS_TEXT(I) :=
				    CHARACTER'val(CHARACTER'pos('0')+MISS_INT rem 10);
				MISS_INT := MISS_INT/10;
			    end loop;

			SET_TEXT(METERS(INSTRUMENTS.MISSILES), MISS_TEXT);
			end;
		    end if;

		when BULLETS =>
		    null;

	    end case;
	end;

	procedure GET(
	    INSTRUMENT  : TEXT_INSTRUMENTS_TYPE;
	    VALUE	: STRING;
	    CHANGED_SINCE_LAST_SCAN : BOOLEAN)
	is
	begin
	    if not CHANGED_SINCE_LAST_SCAN then return; end if;

	    case INSTRUMENT is

		when MESSAGES =>
		    SET_TEXT(METERS(MESSAGES), VALUE);

	    end case;
	end;

	procedure DO_SCAN is new INSTRUMENTS.SCAN(GET, GET, GET);

    begin
	if HAS_INSTRUMENTS then DO_SCAN; end if;
    end;
