--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with LOGICAL_TO_FLOAT, LOGICAL_TO_BOOLEAN, TRIG, VIEW_WINDOW_MANAGER,
    SYSTEM_INTERFACE;

pragma ELABORATE(
    LOGICAL_TO_FLOAT, LOGICAL_TO_BOOLEAN);

separate(INSTRUMENT_PANEL)
    package body INIT_PKG is

	COPYRIGHT_RADIO : constant BOOLEAN
	    := LOGICAL_TO_BOOLEAN("FCTM_COPYRIGHT_RADIO", TRUE);

	procedure INIT is
	    use TRIG;
	begin
	    GRAPHICS_WINDOW_MANAGER.INSTRUMENTS.INIT_INSTRUMENTS(
		VIEW_WINDOW_MANAGER.GW);

	    if not HAS_INSTRUMENTS then return; end if;

	    METERS(INSTRUMENTS.ACCEL) :=
		CREATE_NUMERIC(
		    NAME	=>  "(G's)       ",
		    X		=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_ACCEL_X", 43.0)),
		    Y		=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_ACCEL_Y",  16.0)),
		    HEIGHT	=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_ACCEL_S",  8.0)),
		    WIDTH	=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_ACCEL_S",  8.0)),
		    APPEARANCE	=> DIAL,
		    SCALE	=> LINEAR,

		    LO		=> -10.0,
		    TOP 	=> - 5.0,
		    HI		=> +10.0,

		    INSTRUMENT_VALUE_PER_RADIAN => 20.0/
				    INSTRUMENT_VALUE_TYPE(RADIANS_PER_CIRCLE),
		    RADIANS_PER_NUMBERED_TICK	=>
				    RADIANS(RADIANS_PER_CIRCLE/4.0),
		    TICKS_PER_NUMBERED_TICK	=> 5);

	    METERS(INSTRUMENTS.FUEL) :=
		CREATE_NUMERIC(
		    NAME	=>  "Fuel        ",
		    X		=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_FUEL_X", 84.0)),
		    Y		=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_FUEL_Y",  4.0)),
		    HEIGHT	=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_FUEL_S",  8.0)),
		    WIDTH	=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_FUEL_S",  8.0)),
		    APPEARANCE	=> DIAL,
		    SCALE	=> LINEAR,

		    LO		=>  0.0,
		    TOP 	=>  0.0,
		    HI		=> 10.0,

		    INSTRUMENT_VALUE_PER_RADIAN => 10.0/
				    INSTRUMENT_VALUE_TYPE(RADIANS_PER_CIRCLE),
		    RADIANS_PER_NUMBERED_TICK	=>
				    RADIANS(RADIANS_PER_CIRCLE/1.0),
		    TICKS_PER_NUMBERED_TICK	=> 10);

	    METERS(INSTRUMENTS.ALT) :=
		CREATE_NUMERIC(
		    NAME	=>  "Altitude(ft)",
		    X		=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_ALT_X", 12.0)),
		    Y		=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_ALT_Y",  0.0)),
		    HEIGHT	=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_ALT_S",  20.0)),
		    WIDTH	=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_ALT_S",  20.0)),
		    APPEARANCE	=> DIAL,
		    SCALE	=> CLOCK,

		    LO		=> 0.0,
		    TOP 	=> 0.0,
		    HI		=> 99_999.9,

		    INSTRUMENT_VALUE_PER_RADIAN => 0.0,
		    RADIANS_PER_NUMBERED_TICK	=> 0.0,
		    TICKS_PER_NUMBERED_TICK	=> 1);

	    declare
		SPEED_NAME : INSTRUMENT_NAME_TYPE := "Speed(mph)  ";
	    begin
		if SPEED_IS_CAS then
		    SPEED_NAME(1..5) := " CAS ";
		end if;
		if SPEED_IN_KNOTS then
		    SPEED_NAME(7..9) := "kts";
		end if;
		    
	    METERS(INSTRUMENTS.SPEED) :=
		CREATE_NUMERIC(
		    NAME	=>  SPEED_NAME,
		    X		=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_SPD_X", 62.0)),
		    Y		=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_SPD_Y",  0.0)),
		    HEIGHT	=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_SPD_S",  20.0)),
		    WIDTH	=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_SPD_S",  20.0)),
		    APPEARANCE  => DIAL,
		    SCALE	=> LINEAR,
		    LO		=> 0.0,
		    TOP 	=> 0.0,
		    HI		=> MAX_SPEED,

		    INSTRUMENT_VALUE_PER_RADIAN => MAX_SPEED/
				    INSTRUMENT_VALUE_TYPE(RADIANS_PER_CIRCLE),
		    RADIANS_PER_NUMBERED_TICK	=>
				    RADIANS(RADIANS_PER_CIRCLE/10.0),
		    TICKS_PER_NUMBERED_TICK	=> 5);

	    end;

	    METERS(INSTRUMENTS.MACH) :=
		CREATE_TEXT(
		    NAME	=>  "Mach        ",
		    X		=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_MACH_X", 70.25)),
		    Y		=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_MACH_Y",  4.0)),
		    HEIGHT	=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_MACH_S",  4.0)),
		    WIDTH	=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_MACH_S",  3.5)),
		    MAX_LENGTH  => 3);

	    METERS(INSTRUMENTS.MISSILES) :=
		CREATE_TEXT(
		    NAME	=>  "Missiles    ",
		    X		=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_MISSILE_X",  0.0)),
		    Y		=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_MISSILE_Y",  16.0)),
		    HEIGHT	=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_MISSILE_H",  4.0)),
		    WIDTH	=>
			SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_MISSILE_W",  8.0)),
		    MAX_LENGTH  => 6);

	    METERS(INSTRUMENTS.MISSILE_GUIDANCE) :=
		CREATE_NUMERIC(
		    NAME	=>  "MissileGuide",
		    X		=> 0.0,
		    Y		=> 0.0,
		    HEIGHT	=> 0.0,
		    WIDTH	=> 0.0,
		    APPEARANCE  => CLICKER,
		    SCALE	=> LINEAR,
		    LO		=> 0.0,
		    TOP 	=> 0.0,
		    HI		=> 1.0,
		    INSTRUMENT_VALUE_PER_RADIAN => 0.0,
		    RADIANS_PER_NUMBERED_TICK	=> 0.0,
		    TICKS_PER_NUMBERED_TICK	=> 1);

	    declare
		function F(
		    WHICH : STRING;
		    D_NO_COPYRIGHT, D_COPYRIGHT: SYSTEM_INTERFACE.LONGEST_FLOAT)
		    return SCREEN_MEASUREMENT is

		    D : SYSTEM_INTERFACE.LONGEST_FLOAT;
		begin
		    if COPYRIGHT_RADIO then
			D := D_COPYRIGHT;
		    else
			D := D_NO_COPYRIGHT;
		    end if;
		    return SCREEN_MEASUREMENT(
			LOGICAL_TO_FLOAT("FCTM_INSTRUMENT_MSG_"&WHICH,D));
		end;
	    begin
		METERS(INSTRUMENTS.MESSAGES) :=
		    CREATE_TEXT(
			NAME	    => "Radio       ",
			X	    => F("X", 85.0, 62.0),
			Y	    => F("Y", 21.0, 21.0),
			HEIGHT	    => F("H", 4.0,   4.0),
			WIDTH	    => F("W", 9.0,  30.0),
			MAX_LENGTH  => INTEGER(F("M", 4.0, 40.0)));
		if COPYRIGHT_RADIO then
		    SET_TEXT(
			METERS(INSTRUMENTS.MESSAGES),
			" (c) DIGITAL EQUIPMENT CORPORATION 1991 ");
		end if;
	    end;
	end;
    end;
