--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    LOGICAL_TO_BOOLEAN, LOGICAL_TO_FLOAT,
    SCALAR_PHYSICS, STANDARD_ATMOSPHERE,
    INSTRUMENTS, VIEW_WINDOW_MANAGER, GRAPHICS_WINDOW_MANAGER;

use
    INSTRUMENTS, VIEW_WINDOW_MANAGER, GRAPHICS_WINDOW_MANAGER;

pragma ELABORATE(
    LOGICAL_TO_BOOLEAN, LOGICAL_TO_FLOAT,
    SCALAR_PHYSICS, STANDARD_ATMOSPHERE,
    INSTRUMENTS, GRAPHICS_WINDOW_MANAGER);

package body INSTRUMENT_PANEL is
    use GRAPHICS_WINDOW_MANAGER.INSTRUMENTS;

    HAS_INSTRUMENTS : constant BOOLEAN
	:= LOGICAL_TO_BOOLEAN("FCTM_HAS_INSTRUMENTS", TRUE);

    SPEED_IN_KNOTS : constant BOOLEAN
	:= LOGICAL_TO_BOOLEAN("FCTM_SPEED_IN_KNOTS", TRUE);

    SPEED_IS_CAS : constant BOOLEAN
	:= LOGICAL_TO_BOOLEAN("FCTM_SPEED_IS_CAS", TRUE);

    INVERSE_OF_DENSITY_AT_SEA_LEVEL : constant VALUE_TYPE
	:= 1.0 / VALUE_TYPE(STANDARD_ATMOSPHERE.TO_DENSITY(0.0));

    MAX_SPEED : constant INSTRUMENT_VALUE_TYPE
	:= INSTRUMENT_VALUE_TYPE(LOGICAL_TO_FLOAT("FCTM_MAX_SPEED", 600.0));

    OLD_MISSILE_INT : INTEGER := -1;

    METERS : array(INSTRUMENTS_TYPE) of ACCESS_INSTRUMENT_TYPE;

    package INIT_PKG is
	procedure INIT;
    end;

    package body INIT_PKG is separate;

    procedure INIT is
    begin
	INIT_PKG.INIT;
    end;

    procedure UPDATE is separate;

    procedure FINI is
    begin
	null;
    end;

end;
