--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with IS_DEMO_PKG, VIEW_DIRECTION_CONTROL;

package body INIT_CONTROLS is

    DEFAULT : constant CONTROL_SETTING_TYPE
	    := (STICK_LEFT_RIGHT    => 0.0,
		STICK_FORWARD_BACK  => 0.0,
		FLAP		    => 0,
		RUDDER		    => 0,
		THROTTLE	    => 0,
		AFTERBURNER_ON	    => FALSE,
		SIGHT_ON	    => TRUE,
		MODE		    => 0,

		VD_CONTROL	    => (CONTROL_STATE=>
                                        VIEW_DIRECTION_CONTROL.UNCHANGED),

		TRIGGER1_PRESSED|
		TRIGGER2_PRESSED|
		TRIGGER1_RELEASED|
		TRIGGER2_RELEASED   => FALSE,

		CHANGE_PRESSED	    => FALSE,
		QUIT_PRESSED	    => FALSE,

		MESSAGE_LENGTH	    => 0,
		MESSAGE_TEXT	    => MESSAGE_SUBTYPE'(others=>' '));

    type CLASS_TO_DEFAULT_TYPE is
	array(CONTROLLABLE_CLASS_SUBTYPE) of CONTROL_SETTING_TYPE;

    CLASS_TO_DEFAULT : constant CLASS_TO_DEFAULT_TYPE
	:=  CLASS_TO_DEFAULT_TYPE'(
		MAGIC_CARPET   =>
		   (STICK_LEFT_RIGHT    => 0.0,
		    STICK_FORWARD_BACK  => 0.0,
		    FLAP		=> 0,
		    RUDDER		=> 0,
		    THROTTLE		=> THROTTLE_TYPE'last/2,
		    AFTERBURNER_ON	=> IS_DEMO_PKG.IS_DEMO,
		    SIGHT_ON		=> not IS_DEMO_PKG.IS_DEMO,
		    MODE		=> 0,

		    VD_CONTROL		=> (CONTROL_STATE=>
					    VIEW_DIRECTION_CONTROL.UNCHANGED),

		    TRIGGER1_PRESSED|
		    TRIGGER2_PRESSED|
		    TRIGGER1_RELEASED|
		    TRIGGER2_RELEASED	=> FALSE,

		    CHANGE_PRESSED	=> FALSE,
		    QUIT_PRESSED	=> FALSE,
		    MESSAGE_LENGTH	=> 0,
		    MESSAGE_TEXT	=> MESSAGE_SUBTYPE'(others=>' ')),
		 others =>
		    DEFAULT);


    function GET_INIT_CONTROL_SETTING(
	O : OBJECT_TYPE) return CONTROL_SETTING_TYPE is

	CS : CONTROL_SETTING_TYPE := CLASS_TO_DEFAULT(O.CLASS);
    begin

	-- Tweaks
	--
	case O.CLASS is

	    when AEROPLANE =>
		if O.LOCATION.K > 0.0 then
		    CS.THROTTLE := THROTTLE_TYPE'last;
		    CS.AFTERBURNER_ON := TRUE;
		end if;

	    when others =>
		null;
	end case;

	return CS;
    end;

end;
