--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


package INFO_MANAGER is

    -- Some handles to let each class of objects attach information to an
    -- object.
    --
    type APPEARANCE_INFO_TYPE	is range 0..255;
    type CLASS_INFO_TYPE	is range 0..255;
    type OBJECT_INFO_TYPE	is range 0..255;
    type SUBCLASS_TYPE		is range 0..255;
    type SUBCLASS_INFO_TYPE	is range 0..255;
    type WEAPON_INFO_TYPE	is range 0..255;

    function ASSIGN return APPEARANCE_INFO_TYPE;
    function ASSIGN return CLASS_INFO_TYPE;
    function ASSIGN return OBJECT_INFO_TYPE;
    function ASSIGN return SUBCLASS_TYPE;
    function ASSIGN return SUBCLASS_INFO_TYPE;
    function ASSIGN return WEAPON_INFO_TYPE;

    procedure DEASSIGN(APPEARANCE_INFO	: APPEARANCE_INFO_TYPE);
    procedure DEASSIGN(CLASS_INFO	: CLASS_INFO_TYPE);
    procedure DEASSIGN(OBJECT_INFO	: OBJECT_INFO_TYPE);
    procedure DEASSIGN(SUBCLASS 	: SUBCLASS_TYPE);
    procedure DEASSIGN(SUBCLASS_INFO	: SUBCLASS_INFO_TYPE);
    procedure DEASSIGN(WEAPON_INFO	: WEAPON_INFO_TYPE);

    pragma INLINE(ASSIGN, DEASSIGN);

end;
