--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with INFO_ASSIGN_DEASSIGN_GENERIC_PKG;

package body INFO_MANAGER is

    -- Some handles to let each class of objects attach information to an
    -- object.
    --
    package APPEARANCE_INFO_PKG is
	new INFO_ASSIGN_DEASSIGN_GENERIC_PKG(APPEARANCE_INFO_TYPE, "APPEARANCE");
    package CLASS_INFO_PKG	is
	new INFO_ASSIGN_DEASSIGN_GENERIC_PKG(CLASS_INFO_TYPE, "CLASS");
    package OBJECT_INFO_PKG	is
	new INFO_ASSIGN_DEASSIGN_GENERIC_PKG(OBJECT_INFO_TYPE, "OBJECT");
    package SUBCLASS_PKG	is
	new INFO_ASSIGN_DEASSIGN_GENERIC_PKG(SUBCLASS_TYPE, "SUBCLASS");
    package SUBCLASS_INFO_PKG	is
	new INFO_ASSIGN_DEASSIGN_GENERIC_PKG(SUBCLASS_INFO_TYPE, "SUBCLASS_INFO");
    package WEAPON_INFO_PKG	is
	new INFO_ASSIGN_DEASSIGN_GENERIC_PKG(WEAPON_INFO_TYPE, "WEAPON");

    function ASSIGN return APPEARANCE_INFO_TYPE is
    begin
	return APPEARANCE_INFO_PKG.ASSIGN;
    end;

    function ASSIGN return CLASS_INFO_TYPE is
    begin
	return CLASS_INFO_PKG.ASSIGN;
    end;

    function ASSIGN return OBJECT_INFO_TYPE is
    begin
	return OBJECT_INFO_PKG.ASSIGN;
    end;

    function ASSIGN return SUBCLASS_TYPE is
    begin
	return SUBCLASS_PKG.ASSIGN;
    end;

    function ASSIGN return SUBCLASS_INFO_TYPE is
    begin
	return SUBCLASS_INFO_PKG.ASSIGN;
    end;

    function ASSIGN return WEAPON_INFO_TYPE is
    begin
	return WEAPON_INFO_PKG.ASSIGN;
    end;

    procedure DEASSIGN(APPEARANCE_INFO	: APPEARANCE_INFO_TYPE) is
    begin
	APPEARANCE_INFO_PKG.DEASSIGN(APPEARANCE_INFO);
    end;

    procedure DEASSIGN(CLASS_INFO	: CLASS_INFO_TYPE) is
    begin
	CLASS_INFO_PKG.DEASSIGN(CLASS_INFO);
    end;

    procedure DEASSIGN(OBJECT_INFO	: OBJECT_INFO_TYPE) is
    begin
	OBJECT_INFO_PKG.DEASSIGN(OBJECT_INFO);
    end;

    procedure DEASSIGN(SUBCLASS 	: SUBCLASS_TYPE) is
    begin
	SUBCLASS_PKG.DEASSIGN(SUBCLASS );
    end;

    procedure DEASSIGN(SUBCLASS_INFO	: SUBCLASS_INFO_TYPE) is
    begin
	SUBCLASS_INFO_PKG.DEASSIGN(SUBCLASS_INFO);
    end;

    procedure DEASSIGN(WEAPON_INFO	: WEAPON_INFO_TYPE) is
    begin
	WEAPON_INFO_PKG.DEASSIGN(WEAPON_INFO);
    end;

end;
