--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************

with BUG;
package body INFO_ASSIGN_DEASSIGN_GENERIC_PKG is

    subtype NEXT_FREE_SLOT is INTEGER range 0..255;
    END_OF_SLOTS : constant NEXT_FREE_SLOT := NEXT_FREE_SLOT'first;
    subtype SLOT is INTEGER range END_OF_SLOTS+1..NEXT_FREE_SLOT'last;
    type CHAIN_TYPE is array(SLOT) of NEXT_FREE_SLOT; pragma PACK(CHAIN_TYPE);

    type IN_USE_TYPE;
    type ACCESS_IN_USE_TYPE is access IN_USE_TYPE;
    type IN_USE_TYPE is
	record
	    NEXT	: ACCESS_IN_USE_TYPE;
	    FIRST_FREE	: NEXT_FREE_SLOT;
	    CHAIN	: CHAIN_TYPE;
	end record;

    IN_USE : ACCESS_IN_USE_TYPE;


    function NEW_IN_USE return ACCESS_IN_USE_TYPE is
	I : ACCESS_IN_USE_TYPE := new IN_USE_TYPE;
	IN_USE : IN_USE_TYPE renames I.all;
	CHAIN  : CHAIN_TYPE renames IN_USE.CHAIN;
    begin
	for J in CHAIN'first..CHAIN'last-1 loop CHAIN(J) := J+1; end loop;
	CHAIN(CHAIN'last) := END_OF_SLOTS;
	IN_USE.FIRST_FREE := CHAIN'first;
	return I;
    end;


    function ASSIGN return INFO_TYPE is
	I	: ACCESS_IN_USE_TYPE := IN_USE;
	COUNT   : NATURAL := 0;
    begin
	loop
	    declare
		IN_USE : IN_USE_TYPE renames I.all;
		FIRST_FREE : NEXT_FREE_SLOT renames IN_USE.FIRST_FREE;
	    begin
		-- Get of chain, unless chain empty
		--
		if FIRST_FREE /= END_OF_SLOTS then
		    COUNT := COUNT+FIRST_FREE;
		    FIRST_FREE := IN_USE.CHAIN(FIRST_FREE);
		    return INFO_TYPE(COUNT);
		end if;

		COUNT := COUNT+IN_USE.CHAIN'length;

		-- Move to next, making another to end of list in necessary
		--
		I := IN_USE.NEXT;
		if I = null then
		    I := NEW_IN_USE;
		    IN_USE.NEXT := I;
		end if;

	    end;
	end loop;
    exception
	when others => BUG(SUBSYSTEM&" could not assign any more");
    end;

    procedure DEASSIGN(INFO : INFO_TYPE) is
	I	: ACCESS_IN_USE_TYPE := IN_USE;
	COUNT   : NATURAL := NATURAL(INFO);
    begin
	loop
	    declare
		IN_USE : IN_USE_TYPE renames I.all;
	    begin
		-- find the right chain
		--
		if COUNT in IN_USE.CHAIN'range then
		    -- place it on the front of the chain
		    --
		    IN_USE.CHAIN(COUNT) := IN_USE.FIRST_FREE;
		    IN_USE.FIRST_FREE := COUNT;
		    exit;
		end if;
		COUNT := COUNT - IN_USE.CHAIN'length;
		I := IN_USE.NEXT;
	    end;
	end loop;
    exception
	when others => BUG(SUBSYSTEM & " had failure during DEASSIGN");
    end;

begin
    IN_USE := NEW_IN_USE;
end;
