--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


separate(GRAPHICS_WINDOW_MANAGER)
    task body SYNC_X is

	LIST_OF_WINDOWS : GRAPHICS_WINDOW_TYPE := null;

	-- For MAKE_SEGMENTS_VISIBLE, post-rendezvous
	--
	GC_SET, GC_CLEAR : GC_TYPE;
	DRAWING_LIST_OF_SEGMENTS,
	DRAWN_LIST_OF_SEGMENTS : ACCESS_LIST_OF_SEGMENTS_TYPE;
	WINDOW : WINDOW_TYPE;

	function SCAN_FOR_WINDOW(
	    WINDOW : WINDOW_TYPE)
	    return GRAPHICS_WINDOW_TYPE is

	    GW : GRAPHICS_WINDOW_TYPE := LIST_OF_WINDOWS;
	begin
	    while GW /= null loop
		exit when GW.WINDOW = WINDOW;
		GW := GW.NEXT;
	    end loop;
	    return GW;
	end;

    begin

	-- Main loop
	--
	loop
	    select

		accept CLEAR_WINDOW(GW : in GRAPHICS_WINDOW_TYPE) do
		    CLEAR_WINDOW(DISPLAY, GW.WINDOW);
		    GW.DRAWN_LIST_OF_SEGMENTS.N := 0;
		end;

	    or
		accept CREATE_WINDOW(
		    GW	    : in GRAPHICS_WINDOW_TYPE;
		    X_COORD : WIDTH_PIXEL_COUNT_NATURAL_SUBTYPE;
		    Y_COORD : HEIGHT_PIXEL_COUNT_NATURAL_SUBTYPE;
		    WIDTH   : WIDTH_PIXEL_COUNT_NATURAL_SUBTYPE;
		    HEIGHT  : HEIGHT_PIXEL_COUNT_NATURAL_SUBTYPE) do

		    declare
			GC_VALUES : GC_VALUES_TYPE;
		    begin

			-- Create the window
			--
			GW.WINDOW := 
			    CREATE_WINDOW( DISPLAY	    => DISPLAY,
				PARENT	    => ROOT_WINDOW_OF_SCREEN(SCREEN),
				X	    => X_COORD,
				Y	    => Y_COORD,
				WIDTH	    => WIDTH,
				HEIGHT	    => HEIGHT,
				BORDER_WIDTH=> 0,
				DEPTH	    => DEPTH,
				CLASS	    => INPUT_OUTPUT,
				VISUAL	    => VISUAL,
				VALUE_MASK  => SWA_MASK,
				ATTRIBUTES  => SWA);

			-- Create graphics contexts
			--
			GC_VALUES := GC_VALUES_INIT;
			GC_VALUES.FOREGROUND :=
			    COLORMAP_INDEXS(TO_COLORMAP_INDEXS_RANGE(FORCED_FG_1));
			GC_VALUES.BACKGROUND :=
			    COLORMAP_INDEXS(TO_COLORMAP_INDEXS_RANGE(ALWAYS_BG));

			GW.GC_ALWAYS :=
			    CREATE_GC(
				DISPLAY	=> DISPLAY,
				DRAWABLE => DRAWABLE_TYPE(GW.WINDOW),
				VALUES_MASK	=>(FOREGROUND|BACKGROUND=>TRUE, others=>FALSE),
				VALUES	=> GC_VALUES);

			GC_VALUES := GC_VALUES_INIT;
			GC_VALUES.FOREGROUND :=
			    COLORMAP_INDEXS(TO_COLORMAP_INDEXS_RANGE(ALWAYS_BG));
			GC_VALUES.BACKGROUND :=
			    COLORMAP_INDEXS(TO_COLORMAP_INDEXS_RANGE(FORCED_FG_1));

			GW.GC_ALWAYS_INVERSE :=
			    CREATE_GC(
				DISPLAY	=> DISPLAY,
				DRAWABLE => DRAWABLE_TYPE(GW.WINDOW),
				VALUES_MASK	=>(FOREGROUND|BACKGROUND=>TRUE, others=>FALSE),
				VALUES	=> GC_VALUES);

			GC_VALUES := GC_VALUES_INIT;
			GC_VALUES.FUNC := GX_SET;
			GC_VALUES.PLANE_MASK := PLANE_MASKS(0+PLANE_MASKS'first);
			GC_VALUES.FOREGROUND :=
			    COLORMAP_INDEXS(TO_COLORMAP_INDEXS_RANGE(BG_FG));
			GC_VALUES.BACKGROUND :=
			    COLORMAP_INDEXS(TO_COLORMAP_INDEXS_RANGE(ALWAYS_BG));

			GW.GC_P0_SET :=
			    CREATE_GC(
				DISPLAY	=> DISPLAY,
				DRAWABLE => DRAWABLE_TYPE(GW.WINDOW),
				VALUES_MASK	=>(FUNC|PLANE_MASK|FOREGROUND|BACKGROUND=>TRUE,
						others=>FALSE),
				VALUES	=> GC_VALUES);

			GC_VALUES.FUNC := GX_CLEAR;

			GW.GC_P0_CLEAR :=
			    CREATE_GC(
				DISPLAY	=> DISPLAY,
				DRAWABLE => DRAWABLE_TYPE(GW.WINDOW),
				VALUES_MASK	=>(FUNC|PLANE_MASK|FOREGROUND|BACKGROUND=>TRUE,
						others=>FALSE),
				VALUES	=> GC_VALUES);

			GC_VALUES := GC_VALUES_INIT;
			GC_VALUES.FUNC := GX_SET;
			GC_VALUES.PLANE_MASK := PLANE_MASKS(1+PLANE_MASKS'first);
			GC_VALUES.FOREGROUND :=
			    COLORMAP_INDEXS(TO_COLORMAP_INDEXS_RANGE(FG_BG));
			GC_VALUES.BACKGROUND :=
			    COLORMAP_INDEXS(TO_COLORMAP_INDEXS_RANGE(ALWAYS_BG));

			GW.GC_P1_SET :=
			    CREATE_GC(
				DISPLAY	=> DISPLAY,
				DRAWABLE => DRAWABLE_TYPE(GW.WINDOW),
				VALUES_MASK	=>(FUNC|PLANE_MASK|FOREGROUND|BACKGROUND=>TRUE,
						others=>FALSE),
				VALUES	=> GC_VALUES);

			GC_VALUES.FUNC := GX_CLEAR;
			GW.GC_P1_CLEAR :=
			    CREATE_GC(
				DISPLAY	=> DISPLAY,
				DRAWABLE => DRAWABLE_TYPE(GW.WINDOW),
				VALUES_MASK	=>(FUNC|PLANE_MASK|FOREGROUND|BACKGROUND=>TRUE,
						others=>FALSE),
				VALUES	=> GC_VALUES);


			-- Define the name of the window
			--
			STORE_NAME(
			    DISPLAY     => DISPLAY,
			    WINDOW	=> GW.WINDOW,
			    NAME	=> C_TYPES.NULL_TERMINATED.TO_STRING("FCTM"));

			-- Map the window
			--
			MAP_WINDOW(DISPLAY, GW.WINDOW);
			FLUSH(DISPLAY);

			GW.NEXT := LIST_OF_WINDOWS;
			LIST_OF_WINDOWS := GW;
		    end;
		end;

	    or 
		accept DESTROY_WINDOW(GW : in GRAPHICS_WINDOW_TYPE) do
		    declare
			PREV,THIS : GRAPHICS_WINDOW_TYPE;
		    begin
			PREV := null;
			THIS := LIST_OF_WINDOWS;
			while THIS /= null loop
			    exit when THIS = GW;
			    PREV := THIS;
			    THIS := THIS.NEXT;
			end loop;
			if THIS /= null then
			    if PREV /= null then
				PREV.NEXT := THIS.NEXT;
			    else
				LIST_OF_WINDOWS := THIS.NEXT;
			    end if;
			end if;
			    
			FREE_GC(DISPLAY, GW.GC_ALWAYS);
			FREE_GC(DISPLAY, GW.GC_P0_SET);
			FREE_GC(DISPLAY, GW.GC_P1_SET);
			FREE_GC(DISPLAY, GW.GC_P0_CLEAR);
			FREE_GC(DISPLAY, GW.GC_P1_CLEAR);

			UNMAP_WINDOW(DISPLAY, GW.WINDOW);
			DESTROY_WINDOW(DISPLAY, GW.WINDOW);
			FLUSH(DISPLAY);

		    end;
		end;


	    or
		accept MAKE_SEGMENTS_VISIBLE(GW : in GRAPHICS_WINDOW_TYPE) do
		    declare
			W : WINDOW_INFO_TYPE renames GW.all;
			T : ACCESS_LIST_OF_SEGMENTS_TYPE;
		    begin

			-- Decide how the writing is to be done,
			-- and change for next time
			--
			if PLANE_TO_WRITE = 0 then
			    GC_SET	:= W.GC_P0_SET;
			    GC_CLEAR	:= W.GC_P1_CLEAR;
			    PLANE_TO_WRITE := 1;
			else
			    GC_SET	:= W.GC_P1_SET;
			    GC_CLEAR	:= W.GC_P0_CLEAR;
			    PLANE_TO_WRITE := 0;
			end if;

			-- Remember what to draw
			--
			DRAWING_LIST_OF_SEGMENTS :=
			    W.DRAWING_LIST_OF_SEGMENTS;

			DRAWN_LIST_OF_SEGMENTS :=
			    W.DRAWN_LIST_OF_SEGMENTS;

			WINDOW := W.WINDOW;

			-- Rotate the lists
			--
			T := W.FREE_LIST_OF_SEGMENTS;
			W.FREE_LIST_OF_SEGMENTS := W.DRAWN_LIST_OF_SEGMENTS;
			W.DRAWN_LIST_OF_SEGMENTS := W.DRAWING_LIST_OF_SEGMENTS;
			W.DRAWING_LIST_OF_SEGMENTS := T;

		    end;
		end;

		-- Draw the pending list
		--
		declare
		    S : LIST_OF_SEGMENTS_TYPE renames
			DRAWING_LIST_OF_SEGMENTS.all;
		begin
		    if S.N > 0 then
			DRAW_SEGMENTS(
			    DISPLAY,
			    DRAWABLE_TYPE(WINDOW),
			    GC_SET,
			    S.SEGMENTS(1..S.N));
		    end if;
		end;

		-- Change the color map
		--
		declare
		    FG_BG_PIXEL : COLORMAP_INDEX_TYPE
			renames COLORS(TO_COLORMAP_INDEXS_RANGE(FG_BG)).PIXEL;
		    BG_FG_PIXEL : COLORMAP_INDEX_TYPE
			renames COLORS(TO_COLORMAP_INDEXS_RANGE(BG_FG)).PIXEL;
		    TMP_CI : COLORMAP_INDEX_TYPE;
		begin
		    TMP_CI	:= FG_BG_PIXEL;
		    FG_BG_PIXEL := BG_FG_PIXEL;
		    BG_FG_PIXEL := TMP_CI;
		    STORE_COLORS(DISPLAY, COLORMAP, SWITCHED_COLORS);
		end;

		-- Make it happen on the screen asap
		--
		FLUSH(DISPLAY);

		-- Erase the lines drawn last time
		--
		declare
		    S : LIST_OF_SEGMENTS_TYPE renames
			DRAWN_LIST_OF_SEGMENTS.all;
		begin
		    if S.N > 0 then
			DRAW_SEGMENTS(
			    DISPLAY,
			    DRAWABLE_TYPE(WINDOW),
			    GC_CLEAR,
			    S.SEGMENTS(1..S.N));
			S.N := 0;
		    end if;
		end;


	    or
		accept SCAN_EVENTS do

		    declare
			C	: INTEGER;
			EVENT	: EVENT_TYPE;
			GW	: GRAPHICS_WINDOW_TYPE;
		    begin
			C := EVENTS_QUEUED(DISPLAY, QUEUED_ALREADY);
			if C = 0 then 
			    delay 0.001;
			    C := EVENTS_QUEUED(DISPLAY, QUEUED_AFTER_READING);
			end if;

			for EVENT_COUNTER in 1..C loop

			    NEXT_EVENT(DISPLAY, EVENT);

			    case EVENT.EVENT_NAME is
				when EXPOSE =>
				    GW := SCAN_FOR_WINDOW(
					    EVENT.EXPOSE_EVENT.WINDOW);
				    if GW /= null then
					DRAW_WINDOW(GW);
				    end if;

				when BUTTON_PRESS =>
				    GW := SCAN_FOR_WINDOW(
					    EVENT.BUTTON_EVENT.WINDOW);
				    if GW /= null then
					GW.BUTTONS_DEPRESSED(
					    EVENT.BUTTON_EVENT.BUTTON) := TRUE;
					GW.BUTTONS_PRESSED := TRUE;
				    end if;

				when BUTTON_RELEASE =>
				    GW := SCAN_FOR_WINDOW(
					    EVENT.BUTTON_EVENT.WINDOW);
				    if GW /= null then
					-- X seems to lose some events...
					GW.BUTTONS_DEPRESSED := (others => FALSE);
					GW.BUTTONS_RELEASED  := TRUE;
				    end if;

				when KEY_PRESS =>
				    GW := SCAN_FOR_WINDOW(
					    EVENT.KEY_EVENT.WINDOW);
				    if GW /= null then
					declare
					    W : WINDOW_INFO_TYPE renames GW.all;
					begin
					    if W.KEY_PRESSED < W.KEYCODES_PRESSED'last
					    then
						W.KEY_PRESSED := W.KEY_PRESSED+1;
						W.KEYCODES_PRESSED(W.KEY_PRESSED) :=
						    EVENT.KEY_EVENT.KEYCODE;
					    end if;
					end;
				    end if;

				when KEY_RELEASE =>
				    GW := SCAN_FOR_WINDOW(
					    EVENT.KEY_EVENT.WINDOW);
				    if GW /= null then
					declare
					    W : WINDOW_INFO_TYPE renames GW.all;
					begin
					    if W.KEY_RELEASED < W.KEYCODES_RELEASED'last
					    then
						W.KEY_RELEASED := W.KEY_RELEASED+1;
						W.KEYCODES_RELEASED(W.KEY_RELEASED) :=
						    EVENT.KEY_EVENT.KEYCODE;
					    end if;
					end;
				    end if;

				when MOTION_NOTIFY =>
				    GW := SCAN_FOR_WINDOW(
					    EVENT.MOTION_EVENT.WINDOW);
				    if GW /= null then
					GW.POINTER_X := EVENT.MOTION_EVENT.X;
					GW.POINTER_Y := EVENT.MOTION_EVENT.Y;
				    end if;

				when others =>
				    null;

			    end case;
			end loop;
		    end;
		end;

	    or
		terminate;

	    end select;
	end loop;
    end;
