--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with CONTROLS, TRIG, MENU_MANAGER;
package GRAPHICS_WINDOW_MANAGER is

    type GRAPHICS_WINDOW_TYPE is limited private;

    type SCREEN_MEASUREMENT is digits 6;	-- centimeters

    type X_PIXEL_COUNT is new INTEGER;
    type Y_PIXEL_COUNT is new INTEGER;

    type PIXELS_PER_SCREEN_MEASUREMENT_TYPE is digits 6;

    function X_PIXELS_PER_SCREEN_MEASUREMENT
	return PIXELS_PER_SCREEN_MEASUREMENT_TYPE;

    function Y_PIXELS_PER_SCREEN_MEASUREMENT
	return PIXELS_PER_SCREEN_MEASUREMENT_TYPE;

    procedure CREATE(
	BLX, BLY	: SCREEN_MEASUREMENT;		-- bottom left corner
	WIDTH, HEIGHT   : SCREEN_MEASUREMENT;		--  of where to place
	GRAPHICS_WINDOW : in out GRAPHICS_WINDOW_TYPE);

    procedure DELETE(
	GRAPHICS_WINDOW : in out GRAPHICS_WINDOW_TYPE);


    package MASK is

	procedure ERASE_RECTANGLE(
	    BLX, BLY	    : SCREEN_MEASUREMENT;	-- bottom left corner
	    WIDTH, HEIGHT   : SCREEN_MEASUREMENT;	-- size
	    GRAPHICS_WINDOW : in out GRAPHICS_WINDOW_TYPE);

	procedure FILL_RECTANGLE(
	    BLX, BLY	    : SCREEN_MEASUREMENT;	-- bottom left corner
	    WIDTH, HEIGHT   : SCREEN_MEASUREMENT;	-- size
	    GRAPHICS_WINDOW : in out GRAPHICS_WINDOW_TYPE);

    end;


    function SELECT_FROM_MENU(
	MENU	: in MENU_MANAGER.MENU_TYPE;
	CHOICE	: STRING := "") return NATURAL;


    package CONTROLS is
	use STANDARD.CONTROLS;

	-- Procedures
	--
	procedure UPDATE_NON_VOLATILE_AND_COPY(
	    CONTROL_SETTING : out CONTROL_SETTING_TYPE);

	procedure SET_CONTROLS(
	    CONTROL_SETTING : in CONTROL_SETTING_TYPE;
	    JAMMED	    : BOOLEAN);

	procedure SET_CONTROLS(
	    CONTROL_SETTING : in CONTROL_SETTING_TYPE);

	procedure SET_CONTROLS(
	    JAMMED	    : BOOLEAN);

	procedure INIT_CONTROLS(
	    GRAPHICS_WINDOW : in out GRAPHICS_WINDOW_TYPE;
	    LOW_LEFT_X,
	    LOW_LEFT_Y      : SCREEN_MEASUREMENT;
	    HEIGHT,WIDTH    : SCREEN_MEASUREMENT);

    end;


    package INSTRUMENTS is

	type ACCESS_INSTRUMENT_TYPE is private;

	type INSTRUMENT_NAME_TYPE is new STRING(1..12);

	type INSTRUMENT_APPEARANCE_TYPE is (DIAL, BOX, RULER, CLICKER, BEEPER);
	type INSTRUMENT_SCALE_TYPE is (LINEAR, CLOCK, TEXT);
	type INSTRUMENT_VALUE_TYPE is digits 9; -- three hands*three digits

	subtype NUMERIC_INSTRUMENT_SCALE_TYPE is 
	    INSTRUMENT_SCALE_TYPE range LINEAR..CLOCK;

	type SIGHT_STYLE_TYPE is
	    (CROSS, CIRCLE_WITH_DOT, SMALL_CIRCLE);

	function CREATE_NUMERIC(
	    NAME	    : INSTRUMENT_NAME_TYPE;
	    X, Y	    : SCREEN_MEASUREMENT;
	    HEIGHT,WIDTH    : SCREEN_MEASUREMENT;
	    APPEARANCE	    : INSTRUMENT_APPEARANCE_TYPE;
	    SCALE	    : NUMERIC_INSTRUMENT_SCALE_TYPE;

	    LO, TOP, HI     : INSTRUMENT_VALUE_TYPE := 0.0;

	    INSTRUMENT_VALUE_PER_RADIAN : INSTRUMENT_VALUE_TYPE;
	    RADIANS_PER_NUMBERED_TICK	: TRIG.RADIANS;
	    TICKS_PER_NUMBERED_TICK	: POSITIVE

	    ) return ACCESS_INSTRUMENT_TYPE;

	function CREATE_SIGHT(
	    STYLE	    : SIGHT_STYLE_TYPE;
	    SIZE	    : SCREEN_MEASUREMENT;
	    HOLE_SIZE	    : SCREEN_MEASUREMENT
	    ) return ACCESS_INSTRUMENT_TYPE;

	function CREATE_TEXT(
	    NAME	    : INSTRUMENT_NAME_TYPE;
	    X, Y	    : SCREEN_MEASUREMENT;
	    HEIGHT,WIDTH    : SCREEN_MEASUREMENT;
	    MAX_LENGTH	    : POSITIVE
	    ) return ACCESS_INSTRUMENT_TYPE;

	procedure SET_NUMERIC(
	    INSTRUMENT	    : ACCESS_INSTRUMENT_TYPE;
	    VALUE	    : INSTRUMENT_VALUE_TYPE);

	procedure SET_SIGHT(
	    SIGHT_ON	    : BOOLEAN;
	    X, Y	    : SCREEN_MEASUREMENT);		-- centre

	procedure SET_TEXT(
	    INSTRUMENT	    : ACCESS_INSTRUMENT_TYPE;
	    VALUE	    : STRING);

	procedure UPDATE;

	procedure INIT_INSTRUMENTS(
	    GRAPHICS_WINDOW : in out GRAPHICS_WINDOW_TYPE);

    private
	type INSTRUMENT_TYPE(
		APPEARANCE  : INSTRUMENT_APPEARANCE_TYPE;
		SCALE	    : INSTRUMENT_SCALE_TYPE);
	type ACCESS_INSTRUMENT_TYPE is access INSTRUMENT_TYPE;

    end;



    procedure DRAW_LINE(
	X1		: X_PIXEL_COUNT;
	Y1		: Y_PIXEL_COUNT;
	X2		: X_PIXEL_COUNT;
	Y2		: Y_PIXEL_COUNT;
	GRAPHICS_WINDOW : in out GRAPHICS_WINDOW_TYPE);
	pragma INLINE(DRAW_LINE);

    procedure ERASE(
	GRAPHICS_WINDOW : in out GRAPHICS_WINDOW_TYPE);

    procedure MAKE_VISIBLE(
	GRAPHICS_WINDOW : in out GRAPHICS_WINDOW_TYPE);

private
    type WINDOW_INFO_TYPE;
    type GRAPHICS_WINDOW_TYPE is access WINDOW_INFO_TYPE;

end;
