--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with IS_DEMO_PKG, NYI, UNCHECKED_DEALLOCATION;
separate(GRAPHICS_WINDOW_MANAGER)
    package body GW_MENU_MANAGER is
	use MENU_MANAGER;

	type GW_MENU_TYPE is
	    record
		MENU		: MENU_MANAGER.MENU_TYPE;
		POINTED_TO	: NATURAL		    := 0;
		GRAPHICS_WINDOW	: GRAPHICS_WINDOW_TYPE	    := null;
	    end record;


	function CREATE_MENU(
	    MENU    : in MENU_MANAGER.MENU_TYPE) return ACCESS_GW_MENU_TYPE is
	begin
	    return new GW_MENU_TYPE'(
			MENU		=> MENU,
			POINTED_TO	=> 0,
			GRAPHICS_WINDOW => null);
	end;


	procedure WRITE_MENU_ITEM(
	    MENU        : in GW_MENU_TYPE;
	    POSITION	: NATURAL;
	    INVERSE	: BOOLEAN) is

	    GC		: GC_TYPE;
	    W		: WINDOW_INFO_TYPE renames MENU.GRAPHICS_WINDOW.all;

	    procedure PROCESS(ITEM : in STRING; KEY : in INTEGER) is
	    begin
		DRAW_IMAGE_STRING(
		    DISPLAY,
		    DRAWABLE_TYPE(W.WINDOW),
		    GC,
		    WIDTH_PER_CHAR/4,
		    HEIGHT_PER_CHAR*HEIGHT_PIXEL_COUNT_SUBTYPE(POSITION),
		    ITEM);
	    end;

	    procedure DISPLAY is new PROCESS_ONE_BY_POSITION(PROCESS);

	begin
	    if POSITION = 0 then return; end if;

	    if INVERSE then
		GC := W.GC_ALWAYS_INVERSE;
	    else
		GC := W.GC_ALWAYS;
	    end if;

	    DISPLAY(POSITION, MENU.MENU);
	end;


	procedure DRAW(GW : GRAPHICS_WINDOW_TYPE) is
	begin
	    if GW.MENUS = null then return; end if;

	    for I in 1..LENGTH(GW.MENUS.MENU) loop
		WRITE_MENU_ITEM(GW.MENUS.all, I, I = GW.MENUS.POINTED_TO);
	    end loop;

	end;


	function SELECT_FROM_MENU(
	    MENU	    : in ACCESS_GW_MENU_TYPE;
	    CHOICE	    : STRING := "") return NATURAL is

	    -- The one chosen
	    --
	    CHOSEN_KEY	    : INTEGER := -1;

	    -- loops while showing forced choice
	    --
	    CHOICE_LOOP_COUNT : NATURAL := 0;

	    -- Info about the menu
	    --
	    MENU_LENGTH     : constant NATURAL := MENU_MANAGER.LENGTH(MENU.MENU);
	    MENU_WIDTH	    : constant NATURAL := MENU_MANAGER.WIDTH(MENU.MENU);

	    -- misc
	    --
	    MENU_ABORTED_BY_EXIT_PRESSED : exception;

	    GRAPHICS_WINDOW : GRAPHICS_WINDOW_TYPE;
	    POINTED_TO	    : NATURAL := 0;
	    SHOWING	    : constant BOOLEAN
			    := IS_DEMO_PKG.IS_DEMO or CHOICE = "";

	    -- time to delay while user makes up/changes mind
	    --
	    DELAY_DURATION  : constant DURATION := 0.1;
	    MAX_CHOICE_LOOP_COUNT : constant POSITIVE
			    := 2*BOOLEAN'pos(SHOWING)+1;

	begin

	    if SHOWING then
		-- Create a window, and put the text in it
		--
		CREATE(
		    0,
		    0,
		    WIDTH_PER_CHAR*
			WIDTH_PIXEL_COUNT_SUBTYPE(MENU_WIDTH)
		    + WIDTH_PER_CHAR/2,
		    HEIGHT_PER_CHAR*
			HEIGHT_PIXEL_COUNT_SUBTYPE(MENU_LENGTH)
		    + HEIGHT_PER_CHAR/2,
		    GRAPHICS_WINDOW);

		GRAPHICS_WINDOW.MENUS := MENU;
		MENU.GRAPHICS_WINDOW := GRAPHICS_WINDOW;

		DRAW(GRAPHICS_WINDOW);
	    end if;

	    -- Loop until one selected
	    --
	    loop
		if STANDARD.CONTROLS.EXIT_PRESSED then
		    raise MENU_ABORTED_BY_EXIT_PRESSED;
		end if;

		-- highlight the indicated item, turning off the previous one
		--
		if CHOICE = "" then
		    POINTED_TO :=
			INTEGER(GRAPHICS_WINDOW.POINTER_Y/HEIGHT_PER_CHAR) + 1;
		else
		    if CHOICE_LOOP_COUNT = 0 then
			CHOICE_LOOP_COUNT := MAX_CHOICE_LOOP_COUNT;
			POINTED_TO := POINTED_TO + 1;
		    end if;
		    CHOICE_LOOP_COUNT := CHOICE_LOOP_COUNT - 1;
		end if;

		if POINTED_TO > MENU_LENGTH then
		    POINTED_TO := MENU_LENGTH;
		end if;

		if  SHOWING and then
		    POINTED_TO /= MENU.POINTED_TO
		then
		    if MENU.POINTED_TO /= 0 then
			WRITE_MENU_ITEM(MENU.all, MENU.POINTED_TO, FALSE);
		    end if;
		    MENU.POINTED_TO  := POINTED_TO;
		    WRITE_MENU_ITEM(MENU.all, MENU.POINTED_TO, TRUE);
		end if;

		-- forced choice or
		-- mouse button clicked -> has selected this one
		--
		declare
		    FOUND : BOOLEAN := FALSE;
		    procedure PROCESS(ITEM : in STRING; KEY : in INTEGER) is
		    begin
			FOUND := TRUE;
			CHOSEN_KEY := KEY;
		    end;
		    procedure SCAN is new PROCESS_ONE_BY_ITEM(PROCESS);
		    procedure SCAN is new PROCESS_ONE_BY_POSITION(PROCESS);
		begin
		    if CHOICE /= "" then
			SCAN(CHOICE, MENU.MENU);
			CHOICE_LOOP_COUNT := 0;
		    elsif  GRAPHICS_WINDOW.BUTTONS_DEPRESSED(BUTTON1)
		    then
			if MENU.POINTED_TO /= 0 then
			    SCAN(MENU.POINTED_TO, MENU.MENU);
			end if;
		    end if;
		    exit when FOUND;
		end;

		-- give user time to make up mind, or show the forced choice...
		--
		if SHOWING then delay DELAY_DURATION; end if;
	    end loop;

	    -- Clean up
	    --
	    if SHOWING then DELETE(GRAPHICS_WINDOW); end if;

	    -- return the ITEM_CODE of the one selected
	    --
	    return CHOSEN_KEY;
	end;


	procedure DELETE_MENU(X : in out ACCESS_GW_MENU_TYPE) is

	    procedure DEALLOCATE is
		new UNCHECKED_DEALLOCATION(GW_MENU_TYPE, ACCESS_GW_MENU_TYPE);

	begin
	    DEALLOCATE(X);
	end;


    begin
	null;
    end;
