--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


generic
    type DOMAIN_TYPE is digits <>;
    type RANGE_TYPE  is digits <>;
    type INTERMEDIATE_RESULTS_TYPE is digits <>;

    DOMAIN_FIRST	    : in DOMAIN_TYPE := DOMAIN_TYPE'first;
    DOMAIN_LAST 	    : in DOMAIN_TYPE := DOMAIN_TYPE'last;
    NUMBER_OF_SUBDOMAINS    : in POSITIVE := 1024;

package GENERIC_TABLE_LOOKUP is
    type TABLE_TYPE is private;

    function F(TABLE : TABLE_TYPE; X : DOMAIN_TYPE) return RANGE_TYPE;

    generic
	with procedure GET_PAIR(
	    I		: POSITIVE;
	    CONTINUE    : in out BOOLEAN;  -- set FALSE when I is last available
	    D		: out DOMAIN_TYPE; -- I1 < I2 must imply D1 < D2
	    R		: out RANGE_TYPE);
    procedure GENERIC_CREATE(TABLE : out TABLE_TYPE);

private
    subtype DT is DOMAIN_TYPE;
    subtype RT is RANGE_TYPE;
    subtype IT is INTERMEDIATE_RESULTS_TYPE;
    type COEFFICIENTS_TYPE is record A, B : IT; end record;
    type TABLE_TYPE is array(0..NUMBER_OF_SUBDOMAINS-1) of COEFFICIENTS_TYPE;
end; pragma INLINE_GENERIC(GENERIC_TABLE_LOOKUP);


package body GENERIC_TABLE_LOOKUP is

    SUBDOMAIN_LENGTH : constant IT
	:= IT(DOMAIN_LAST-DOMAIN_FIRST)/IT(NUMBER_OF_SUBDOMAINS);

    function TO_DOMAIN(N : INTEGER) return DT is
    begin
	return DT(IT(N-TABLE_TYPE'first)*SUBDOMAIN_LENGTH)+DOMAIN_FIRST;
    end;

    function TO_TABLE_INDEX(X : DOMAIN_TYPE) return INTEGER is
	N   : INTEGER
	    := INTEGER(IT(X - DOMAIN_FIRST)/SUBDOMAIN_LENGTH)+TABLE_TYPE'first;
    begin
	if    N < TABLE_TYPE'first then N := TABLE_TYPE'first;
	elsif N > TABLE_TYPE'last  then N := TABLE_TYPE'last;
	end if;
	return N;
    end;    pragma INLINE(TO_TABLE_INDEX);

    function F(TABLE : TABLE_TYPE; X : DOMAIN_TYPE) return RANGE_TYPE is
	C : COEFFICIENTS_TYPE renames TABLE(TO_TABLE_INDEX(X));
    begin
	return RT(C.A*IT(X)+C.B);
    end;

    procedure GENERIC_CREATE(TABLE : out TABLE_TYPE) is
	CONTINUE : BOOLEAN := TRUE;
	D,
	D1, D2	: DT;
	R1, R2	: RT;
	A, B	: IT;
	I,
	TI	: INTEGER;
    begin
	I := 1;
	GET_PAIR(I, CONTINUE, D2, R2);
	D1 := TO_DOMAIN(TABLE'first);
	R1 := R2;
	A := 0.0;
	B := IT(R1);

	TI := TABLE'first;
	loop
	    while TI <= TABLE'last loop
		D := TO_DOMAIN(TI);
		exit when D2 < D;
		TABLE(TI) := (A, B);
		TI := TI+1;
	    end loop;
	    exit when TABLE'last < TI;
	    D1 := D2;
	    R1 := R2;
	    if CONTINUE then
		I := I+1;
		GET_PAIR(I, CONTINUE, D2, R2);
		A := IT(R2-R1)/IT(D2-D1);
		B := IT(R1)-A*IT(D1);
	    else
		D2 := DOMAIN_TYPE'last;
		R2 := R1;
		A := 0.0;
		B := IT(R1);
	    end if;
	end loop;

    end;
end;
