--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    VIEW_WINDOW_MANAGER, LOGICAL_TO_FLOAT, AOA_INDICATOR;

pragma ELABORATE(
    VIEW_WINDOW_MANAGER, LOGICAL_TO_FLOAT, AOA_INDICATOR);

separate(GENERATE_NEXT_VIEW)
    package body DRAW_PAIR_PKG is
	use GRAPHICS_WINDOW_MANAGER;

	X_PIXELS_PER_SCALE_TYPE : constant SCALE_TYPE
	    :=	SCALE_TYPE(SCREEN_PLACEMENT.SCREEN_MEASUREMENTS_PER_METRE) *
		SCALE_TYPE(X_PIXELS_PER_SCREEN_MEASUREMENT);

	Y_PIXELS_PER_SCALE_TYPE : constant SCALE_TYPE
	    :=	SCALE_TYPE(SCREEN_PLACEMENT.SCREEN_MEASUREMENTS_PER_METRE) *
		SCALE_TYPE(Y_PIXELS_PER_SCREEN_MEASUREMENT);

	INSTRUMENT_PANEL_Y_PIXEL : constant Y_PIXEL_COUNT
	    :=	Y_PIXEL_COUNT(
		    PIXELS_PER_SCREEN_MEASUREMENT_TYPE(
			VIEW_WINDOW_MANAGER.INSTRUMENT_PANEL_HEIGHT)*
		    Y_PIXELS_PER_SCREEN_MEASUREMENT);


	function SCALE_TYPE_TO_X_PIXEL(X : SCALE_TYPE)
	return X_PIXEL_COUNT is
	begin
	    return
		X_PIXEL_COUNT(
		    X *
		    X_PIXELS_PER_SCALE_TYPE);
	end;	pragma INLINE(SCALE_TYPE_TO_X_PIXEL);


	function SCALE_TYPE_TO_Y_PIXEL(Y : SCALE_TYPE)
	return Y_PIXEL_COUNT is
	begin
	    return
		Y_PIXEL_COUNT(
		    Y *
		    Y_PIXELS_PER_SCALE_TYPE);
	end;	pragma INLINE(SCALE_TYPE_TO_Y_PIXEL);


	procedure DRAW_LINE(X1, Y1, X2, Y2 : SCALE_TYPE) is
	begin
	    DRAW_LINE(
		SCALE_TYPE_TO_X_PIXEL(X1),
		SCALE_TYPE_TO_Y_PIXEL(Y1)+INSTRUMENT_PANEL_Y_PIXEL,
		SCALE_TYPE_TO_X_PIXEL(X2),
		SCALE_TYPE_TO_Y_PIXEL(Y2)+INSTRUMENT_PANEL_Y_PIXEL,
		VIEW_WINDOW_MANAGER.GW);
	end;	pragma INLINE(DRAW_LINE);


	procedure PROJECT(
	    P_I, P_J, P_K   : SCALE_TYPE;
	    X, Y	    : out SCALE_TYPE) is

	    SCALE_FACTOR    : constant SCALE_TYPE
			    := SCREEN_PLACEMENT.DISTANCE/P_J;

	begin
	    X := SCREEN_PLACEMENT.LEFT + P_I*SCALE_FACTOR;
	    Y := SCREEN_PLACEMENT.DOWN + P_K*SCALE_FACTOR;
	end;


	procedure DRAW_PAIR_NO_CLIPPING(
	    A_XY_INFO	    : in XY_INFO_TYPE;
	    A, B	    : in VIEW_PHYSICS.POSITION;
	    B_XY_INFO	    : out XY_INFO_TYPE) is

	    use
		SCALAR_PHYSICS,
		VIEW_PHYSICS, VIEW_WINDOW_MANAGER;

	    A_I, A_J, A_K,
	    B_I, B_J, B_K   : SCALE_TYPE;

	    A_X, A_Y,
	    B_X, B_Y	    : SCALE_TYPE;


	begin

	    if A_XY_INFO.VALID then
		A_X := A_XY_INFO.X;
		A_Y := A_XY_INFO.Y;
	    else
		PROJECT(SCALE_TYPE(A.I), SCALE_TYPE(A.J), SCALE_TYPE(A.K),
		    A_X,A_Y);
	    end if;

	    PROJECT(SCALE_TYPE(B.I), SCALE_TYPE(B.J), SCALE_TYPE(B.K), B_X,B_Y);

	    B_XY_INFO.VALID := TRUE;
	    B_XY_INFO.X := B_X;
	    B_XY_INFO.Y := B_Y;

	    DRAW_LINE(A_X, A_Y, B_X, B_Y);

	end;

	procedure DRAW_PAIR_CLIPPING(
	    CLIPPING_INFO   : in CLIPPING_INFO_TYPE;
	    A_XY_INFO	    : in XY_INFO_TYPE;
	    A, B	    : in VIEW_PHYSICS.POSITION;
	    B_XY_INFO	    : out XY_INFO_TYPE) is

	    use
		SCALAR_PHYSICS,
		VIEW_PHYSICS, VIEW_WINDOW_MANAGER;

	    A_I, A_J, A_K,
	    B_I, B_J, B_K   : SCALE_TYPE;

	    A_X, A_Y,
	    B_X, B_Y	    : SCALE_TYPE;


	begin

	    if not CLIPPING_INFO.SOME_CLIPPING then
		DRAW_PAIR_NO_CLIPPING(A_XY_INFO, A, B,  B_XY_INFO);
		return;
	    end if;

	    B_XY_INFO.VALID := FALSE;

	    -- Make the point with the least J co-ordinate A_*, the other B_*
	    -- Return if both points are in front of the screen.
	    --
	    if A.J <= B.J then
		B_J := SCALE_TYPE(B.J);
		if B_J <= SCREEN_PLACEMENT.DISTANCE+METRES'small then
		    return;
		end if;

		A_I := SCALE_TYPE(A.I);
		A_J := SCALE_TYPE(A.J);
		A_K := SCALE_TYPE(A.K);

		B_I := SCALE_TYPE(B.I);
		B_K := SCALE_TYPE(B.K);
	    else
		B_J := SCALE_TYPE(A.J);
		if B_J <= SCREEN_PLACEMENT.DISTANCE+METRES'small then
		    return;
		end if;

		B_I := SCALE_TYPE(A.I);
		B_K := SCALE_TYPE(A.K);

		A_I := SCALE_TYPE(B.I);
		A_J := SCALE_TYPE(B.J);
		A_K := SCALE_TYPE(B.K);
	    end if;

	    if A_J <= SCREEN_PLACEMENT.DISTANCE then

		declare

		    B_SCALE_FACTOR : constant SCALE_TYPE :=
			(SCREEN_PLACEMENT.DISTANCE-A_J)/(B_J-A_J);

		    A_SCALE_FACTOR : constant SCALE_TYPE :=
			1.0 - B_SCALE_FACTOR;

		begin
		    A_I := A_SCALE_FACTOR*A_I + B_SCALE_FACTOR*B_I;
		    A_J := SCREEN_PLACEMENT.DISTANCE;
		    A_K := A_SCALE_FACTOR*A_K + B_SCALE_FACTOR*B_K;
		end;

	    end if;

	    PROJECT(A_I, A_J, A_K, A_X, A_Y);
	    PROJECT(B_I, B_J, B_K, B_X, B_Y);

	    declare

		procedure CLIP(
		    Q1_TARGET   : SCALE_TYPE;
		    P1,P2	: SCALE_TYPE;
		    Q1,Q2	: in out SCALE_TYPE) is

		    P_SCALE_FACTOR : constant SCALE_TYPE :=
			(Q1_TARGET-Q1)/(P1-Q1);

		    Q_SCALE_FACTOR : constant SCALE_TYPE :=
			1.0 - P_SCALE_FACTOR;

		begin
		    Q1 := Q1_TARGET;
		    Q2 := P_SCALE_FACTOR*P2 + Q_SCALE_FACTOR*Q2;
		end;

	    begin
		if CLIPPING_INFO.LEFT_OR_RIGHT then

		    -- make A the point to the left
		    --
		    if A_X > B_X then
			declare
			    T : SCALE_TYPE;
			begin
			    T := A_X; A_X := B_X; B_X := T;
			    T := A_Y; A_Y := B_Y; B_Y := T;
			end;
		    end if;

		    -- Totally left or right
		    --
		    if B_X < 0.0 or SCREEN_PLACEMENT.WIDTH < A_X then
			return;
		    end if;

		    -- Partially left
		    --
		    if A_X < 0.0 then
			CLIP(0.0, B_X, B_Y, A_X, A_Y);
		    end if;

		    -- Partially right
		    --
		    if SCREEN_PLACEMENT.WIDTH < B_X then
			CLIP(SCREEN_PLACEMENT.WIDTH, A_X, A_Y, B_X, B_Y);
		    end if;
		end if;

		if CLIPPING_INFO.UP_OR_DOWN then

		    -- make A the lower point
		    --
		    if A_Y > B_Y then
			declare
			    T : SCALE_TYPE;
			begin
			    T := A_X; A_X := B_X; B_X := T;
			    T := A_Y; A_Y := B_Y; B_Y := T;
			end;
		    end if;

		    -- totally above or below
		    --
		    if B_Y < 0.0 or SCREEN_PLACEMENT.HEIGHT < A_Y then
			return;
		    end if;

		    -- Below
		    --
		    if A_Y < 0.0 then
			CLIP(0.0, B_Y, B_X, A_Y, A_X);
		    end if;

		    -- Above
		    --
		    if SCREEN_PLACEMENT.HEIGHT < B_Y then
			CLIP(SCREEN_PLACEMENT.HEIGHT, A_Y, A_X, B_Y, B_X);
		    end if;
		end if;
	    end;

	    DRAW_LINE(A_X, A_Y, B_X, B_Y);

	end;
    end;
pragma SUPPRESS_ALL;
