--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    VIEW_MANAGER,
    SCALAR_PHYSICS,
    WORLD_PHYSICS, OBJECT_PHYSICS,
    APPEARANCE_MANAGER, OBJECTS;
with
    NYI;
pragma ELABORATE(
    VIEW_MANAGER,
    SCALAR_PHYSICS,
    WORLD_PHYSICS, OBJECT_PHYSICS,
    APPEARANCE_MANAGER);

separate(GENERATE_NEXT_VIEW)
    procedure DRAW_OBJECT(O : OBJECTS.OBJECT_TYPE) is
	use SCALAR_PHYSICS;

	OBJECT_BASIS_NOT_PROJECTED : BOOLEAN := TRUE;

	OBJECT_BASIS  : VIEW_PHYSICS.POSITION_BASIS;
	OBJECT_ORIGIN : VIEW_PHYSICS.POSITION;

	procedure PROJECT_WORLD_TO_VIEW_SAME_ORIGIN(
	    WP : in  WORLD_PHYSICS.POSITION;
	    VP : out VIEW_PHYSICS.POSITION) is
	begin
-- 3.5% of the CPU time was being spent here
--	    WORLD_PHYSICS.PROJECT_SAME_ORIGIN(
--		VIEW_MANAGER.VIEW_POINT_READ_ONLY.ORIENTATION.I,
--		VIEW_MANAGER.VIEW_POINT_READ_ONLY.ORIENTATION.J,
--		VIEW_MANAGER.VIEW_POINT_READ_ONLY.ORIENTATION.K,
--		WP,
--		VP.I, VP.J, VP.K);
	    declare
		WP_I : constant METRES := WP.I;
		WP_J : constant METRES := WP.J;
		WP_K : constant METRES := WP.K;
	    begin
		VP.I := WP_I*VIEW_MANAGER.VIEW_POINT_READ_ONLY.ORIENTATION.I.I
		     +  WP_J*VIEW_MANAGER.VIEW_POINT_READ_ONLY.ORIENTATION.I.J
		     +  WP_K*VIEW_MANAGER.VIEW_POINT_READ_ONLY.ORIENTATION.I.K;
		VP.J := WP_I*VIEW_MANAGER.VIEW_POINT_READ_ONLY.ORIENTATION.J.I
		     +  WP_J*VIEW_MANAGER.VIEW_POINT_READ_ONLY.ORIENTATION.J.J
		     +  WP_K*VIEW_MANAGER.VIEW_POINT_READ_ONLY.ORIENTATION.J.K;
		VP.K := WP_I*VIEW_MANAGER.VIEW_POINT_READ_ONLY.ORIENTATION.K.I
		     +  WP_J*VIEW_MANAGER.VIEW_POINT_READ_ONLY.ORIENTATION.K.J
		     +  WP_K*VIEW_MANAGER.VIEW_POINT_READ_ONLY.ORIENTATION.K.K;
	    end;
	end; pragma INLINE(PROJECT_WORLD_TO_VIEW_SAME_ORIGIN);

	procedure PROJECT_OBJECT_BASIS is
	begin
	    PROJECT_WORLD_TO_VIEW_SAME_ORIGIN(
		O.ORIENTATION.I, OBJECT_BASIS.I);

	    PROJECT_WORLD_TO_VIEW_SAME_ORIGIN(
		O.ORIENTATION.J, OBJECT_BASIS.J);

	    PROJECT_WORLD_TO_VIEW_SAME_ORIGIN(
		O.ORIENTATION.K, OBJECT_BASIS.K);

	    OBJECT_BASIS_NOT_PROJECTED := FALSE;
	end;


	procedure OBJECT_TO_VIEW(
	    OP : in  OBJECT_PHYSICS.POSITION;
	    VP : out VIEW_PHYSICS.POSITION) is 

	    use VIEW_PHYSICS;

	begin
--
--	This procedure was taking up 25% of the TOTAL cpu time for FCTM
--	hence this hand optimization.
--
--	    ADD(  OBJECT_BASIS.I*SCALE_TYPE(OP.I) +
--		  OBJECT_BASIS.J*SCALE_TYPE(OP.J),
--		  OBJECT_BASIS.K*SCALE_TYPE(OP.K) +
--		  OBJECT_ORIGIN,
--		  VP);
--	
	declare
	    OP_I : constant SCALE_TYPE := SCALE_TYPE(OP.I);
	    OP_J : constant SCALE_TYPE := SCALE_TYPE(OP.J);
	    OP_K : constant SCALE_TYPE := SCALE_TYPE(OP.K);
	begin

	    VP.I :=
		OBJECT_BASIS.I.I*OP_I + 
		OBJECT_BASIS.J.I*OP_J + 
		OBJECT_BASIS.K.I*OP_K +
		OBJECT_ORIGIN.I;

	    VP.J :=
		OBJECT_BASIS.I.J*OP_I + 
		OBJECT_BASIS.J.J*OP_J + 
		OBJECT_BASIS.K.J*OP_K +
		OBJECT_ORIGIN.J;

	    VP.K :=
		OBJECT_BASIS.I.K*OP_I + 
		OBJECT_BASIS.J.K*OP_J + 
		OBJECT_BASIS.K.K*OP_K +
		OBJECT_ORIGIN.K;

	    end;
	end;	pragma INLINE(OBJECT_TO_VIEW);


    begin
	-- Find out where the object is relative to the view,
	-- in the viewer's coordinate space.
	--
	PROJECT_WORLD_TO_VIEW_SAME_ORIGIN(
	    WORLD_PHYSICS.POSITION'(
		METRES(OBJECTS."-"(O.LOCATION.I,
			VIEW_MANAGER.VIEW_POINT_READ_ONLY.ORIGIN.I)),
		METRES(OBJECTS."-"(O.LOCATION.J,
			VIEW_MANAGER.VIEW_POINT_READ_ONLY.ORIGIN.J)),
		METRES(OBJECTS."-"(O.LOCATION.K,
			VIEW_MANAGER.VIEW_POINT_READ_ONLY.ORIGIN.K))),
	    OBJECT_ORIGIN);

	-- Now project each point in the object into the viewer's coordinate
	-- system, and draw the resulting lines.
	--
	declare
	    use APPEARANCE_MANAGER;
	    AA  : constant ACCESS_APPEARANCE_TYPE
		:= TO_ACCESS_APPEARANCE_TYPE(O.APPEARANCE_INFO);
	    AP	: ACCESS_PICTURE_TYPE
		:= APPEARANCE_TO_PICTURE(AA);
	    CLIPPING_INFO : CLIPPING_INFO_TYPE;

	    -- Note as "near" if it is close enough...
	    --
	    VISIBILITY : constant METRES :=
		(abs(OBJECT_ORIGIN.I) +
		 abs(OBJECT_ORIGIN.J) +
		 abs(OBJECT_ORIGIN.K));

	begin

	    GET_CLIPPING_INFO(O, OBJECT_ORIGIN, CLIPPING_INFO);

	    if CLIPPING_INFO.NOT_VISIBLE then AP := null; end if;

SUBPICTURES_LOOP :
	    while AP /= null loop

		-- Draw this subpicture
		--
		declare
		    P : PICTURE_TYPE renames AP.all;
		    LINE_ENDS : array(1..2) of VIEW_PHYSICS.POSITION;
		begin

-- inefficient code generated for this
--		    if  VISIBILITY not in
--			P.CLOSEST_VISIBLE..P.FURTHEREST_VISIBLE
--
		    if VISIBILITY < P.CLOSEST_VISIBLE
		    or P.FURTHEREST_VISIBLE < VISIBILITY
		    then
			null;

		    elsif P.COUNT /= 0 then

			if CLIPPING_INFO.ZERO_RADIUS then
			    --
			    -- special case points for efficiency (eg: bullets)
			    --
			    declare
				XY_INFO : array(1..2) of XY_INFO_TYPE;
			    begin
				XY_INFO(1).VALID := FALSE;
				XY_INFO(2).VALID := FALSE;
				DRAW_PAIR_NO_CLIPPING(
				    XY_INFO(1),
				    OBJECT_ORIGIN,
				    OBJECT_ORIGIN,
				    XY_INFO(2));
			    end;
			else
			    if OBJECT_BASIS_NOT_PROJECTED then
				PROJECT_OBJECT_BASIS;
			    end if;

			    OBJECT_TO_VIEW(P.POINTS(1), LINE_ENDS(1));

			    if P.COUNT = 1 then
				--
				-- single point
				--
				declare
				    XY_INFO	: array(1..2) of XY_INFO_TYPE;
				begin
				    XY_INFO(1).VALID := FALSE;
				    DRAW_PAIR_CLIPPING(
					CLIPPING_INFO,
					XY_INFO(1),
					LINE_ENDS(1),
					LINE_ENDS(1),
					XY_INFO(2));
				end;
			    else
				-- multiple points
				--
				declare
				    SWAP_END,
				    THIS_END,
				    NEXT_END : NATURAL range 1..2;
				    XY_INFO  : array(1..2) of XY_INFO_TYPE;
				begin
				    THIS_END := 1;
				    NEXT_END := 2;
				    XY_INFO(1).VALID := FALSE;
				    XY_INFO(2).VALID := FALSE;
				    for I in 2..P.COUNT loop

					OBJECT_TO_VIEW(P.POINTS(I),
					    LINE_ENDS(NEXT_END));

					if not CLIPPING_INFO.SOME_CLIPPING then
					    DRAW_PAIR_NO_CLIPPING(
						XY_INFO(THIS_END),
						LINE_ENDS(THIS_END),
						LINE_ENDS(NEXT_END),
						XY_INFO(NEXT_END));
					else
					    DRAW_PAIR_CLIPPING(
						CLIPPING_INFO,
						XY_INFO(THIS_END),
						LINE_ENDS(THIS_END),
						LINE_ENDS(NEXT_END),
						XY_INFO(NEXT_END));
					end if;

					SWAP_END := NEXT_END;
					NEXT_END := THIS_END;
					THIS_END := SWAP_END;
				    end loop;
				end;
			    end if;
			end if;
		    end if;
		end;

		AP := AP.NEXT_SUBPICTURE;
	    end loop SUBPICTURES_LOOP;

	end;
    end;
pragma SUPPRESS_ALL;
