--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    CONTROLS, WORLD_PHYSICS, VIEW_MANAGER, VIEW_DIRECTION_MANAGER,
    SIGHT, IS_DEMO_PKG;

separate(GENERATE_NEXT_VIEW)
    procedure DRAW_NEXT_VIEW(
	MAINTAINER_TO_ACCESS_OBJECT : OBJECTS.MAINTAINER_TO_ACCESS_OBJECT_TYPE;
	LEAVE_AS_BLANK		    : BOOLEAN := FALSE)
    is
	use CONTROLS, VIEW_DIRECTION_MANAGER, WORLD_PHYSICS;
    begin

	-- Set the view point
	--
	VIEW_MANAGER.UPDATE_VIEWPOINT;

	-- for each object to be seen loop DRAW_OBJECT; end loop;
	--
	if not LEAVE_AS_BLANK then
	    for I in MAINTAINER_TO_ACCESS_OBJECT'range loop
		declare
		    A   : OBJECTS.ACCESS_OBJECT_TYPE
			:= MAINTAINER_TO_ACCESS_OBJECT(I);
		begin
		    while A /= null loop
			if  A /= VIEW_MANAGER.OBJECT_VIEWED_FROM then
			    DRAW_OBJECT(A.all);
			end if;
			A := A.NEXT;
		    end loop;
		end;
	    end loop;
	end if;

	-- Draw orientation marks
	--
	DRAW_PAIR_PKG.ORIENTATION_MARKS_DRAWN :=
	    not DRAW_PAIR_PKG.ORIENTATION_MARKS_DRAWN;

	if  VIEW_MANAGER.ORIENTATION_MARKS /= null
	and DRAW_PAIR_PKG.ORIENTATION_MARKS_DRAWN
	then
	    DRAW_OBJECT(VIEW_MANAGER.ORIENTATION_MARKS.all);
	end if;

	-- Draw sights
	--
	if not IS_DEMO_PKG.IS_DEMO
	and SIGHT.ACQUIRED_SIGHT_OBJECT /= null
	then
	    DRAW_OBJECT(SIGHT.ACQUIRED_SIGHT_OBJECT.all);
	end if;

	-- Make all the instruments show the latest values
	--
	GRAPHICS_WINDOW_MANAGER.INSTRUMENTS.UPDATE;

	-- Make all the drawn objects visible
	--
	GRAPHICS_WINDOW_MANAGER.MAKE_VISIBLE(VIEW_WINDOW_MANAGER.GW);

    end;

