--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    LOGICAL_TO_BOOLEAN,
    LOGICAL_TO_FLOAT,
    APPEARANCE_MANAGER,
    GRAPHICS_WINDOW_MANAGER,
    VIEW_WINDOW_MANAGER,
    OBJECT_PHYSICS, VIEW_PHYSICS;

with OBJECTS, SCALAR_PHYSICS;
use  OBJECTS, SCALAR_PHYSICS;

pragma ELABORATE(
    LOGICAL_TO_BOOLEAN,
    LOGICAL_TO_FLOAT,
    GRAPHICS_WINDOW_MANAGER);

package body GENERATE_NEXT_VIEW is

    package SCREEN_PLACEMENT is

	SCREEN_MEASUREMENTS_PER_METRE : constant := 10.0;

	WIDTH	: constant SCALE_TYPE
		:= SCALE_TYPE(VIEW_WINDOW_MANAGER.WIDTH)
		    /SCREEN_MEASUREMENTS_PER_METRE;

	LEFT	: constant SCALE_TYPE
		:= WIDTH/2.0;

	RIGHT	: constant SCALE_TYPE
		:= SCALE_TYPE(VIEW_WINDOW_MANAGER.WIDTH)
		    /SCREEN_MEASUREMENTS_PER_METRE - LEFT;

	HEIGHT	: constant SCALE_TYPE
		:= SCALE_TYPE(VIEW_WINDOW_MANAGER.HEIGHT)
		    /SCREEN_MEASUREMENTS_PER_METRE;

	UP	: constant SCALE_TYPE
		:= HEIGHT*0.66;

	DOWN	: constant SCALE_TYPE
		:= HEIGHT-UP;

	DISTANCE: constant SCALE_TYPE
		:= WIDTH/SCALE_TYPE(
			LOGICAL_TO_FLOAT("FCTM_FOCAL_RATIO", 1.5));

    end;

    type XY_INFO_TYPE is
	record
	    VALID : BOOLEAN;
	    X,Y   : SCALE_TYPE;
	end record;

    package CLIPPING_INFO_PKG is

	type CLIPPING_INFO_TYPE is
		record
		    NOT_VISIBLE,
		    SOME_CLIPPING,
		    FRONT_OR_BACK,
		    LEFT_OR_RIGHT,
		    UP_OR_DOWN,
		    ZERO_RADIUS : BOOLEAN;
		end record;

	for CLIPPING_INFO_TYPE use
		record
		    NOT_VISIBLE     at 0 range 0..7;
		    SOME_CLIPPING   at 1 range 0..7;
		    FRONT_OR_BACK   at 2 range 0..7;
		    LEFT_OR_RIGHT   at 3 range 0..0;
		    UP_OR_DOWN	    at 3 range 1..1;
		    ZERO_RADIUS     at 3 range 2..7;
		end record;

	for CLIPPING_INFO_TYPE'size use 32;

	procedure GET_CLIPPING_INFO(
	    O		    : OBJECTS.OBJECT_TYPE;
	    OBJECT_ORIGIN   : VIEW_PHYSICS.POSITION;
	    CLIPPING_INFO   : out CLIPPING_INFO_TYPE);
    end;
    use CLIPPING_INFO_PKG;

    package body CLIPPING_INFO_PKG is separate;

    package DRAW_PAIR_PKG is
	ORIENTATION_MARKS_DRAWN : BOOLEAN := FALSE;
	procedure DRAW_PAIR_NO_CLIPPING(
	    A_XY_INFO	    : in XY_INFO_TYPE;
	    A, B	    : in VIEW_PHYSICS.POSITION;
	    B_XY_INFO	    : out XY_INFO_TYPE);
	    pragma INLINE(DRAW_PAIR_NO_CLIPPING);
	procedure DRAW_PAIR_CLIPPING(
	    CLIPPING_INFO   : in CLIPPING_INFO_TYPE;
	    A_XY_INFO	    : in XY_INFO_TYPE;
	    A, B	    : in VIEW_PHYSICS.POSITION;
	    B_XY_INFO	    : out XY_INFO_TYPE);
    end;
    use DRAW_PAIR_PKG;

    package body DRAW_PAIR_PKG is separate;

    procedure DRAW_OBJECT(
	O : OBJECTS.OBJECT_TYPE) is separate;

    procedure DRAW_NEXT_VIEW(
	MAINTAINER_TO_ACCESS_OBJECT : OBJECTS.MAINTAINER_TO_ACCESS_OBJECT_TYPE;
	LEAVE_AS_BLANK		    : BOOLEAN := FALSE)
	is separate;

end;
