--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with SYSTEM_INTERFACE, SYSTEM_ADDRESS_INT, UNCHECKED_CONVERSION;
use  SYSTEM_INTERFACE, SYSTEM_ADDRESS_INT;

with SYSTEM;

separate(FLIGHT_RECORDER)
    package body FILE_MANAGER is

	SECTION_SIZE	: constant INTEGER := 12_000*512;
	SECTION_RANGE	: array(0..1) of ADDRESS := (others => ADDRESS_ZERO);
	NEXT_ADDRESS	: ADDRESS := ADDRESS_ZERO;

	NUMBER_OF_ITEMS_TO_BYTE_SIZE :
	    array(NUMBER_OF_ITEMS_RANGE) of INTEGER;

	function TO_ACCESS_TAPE_TYPE is
	    new UNCHECKED_CONVERSION(ADDRESS, ACCESS_TAPE_TYPE);


	function ALLOCATE(NUMBER_OF_ITEMS : NUMBER_OF_ITEMS_RANGE)
	    return ACCESS_TAPE_TYPE is

	    A : ADDRESS := NEXT_ADDRESS;

	begin
	    if NEXT_ADDRESS = ADDRESS_ZERO then
		return null;
	    end if;

	    -- Allocate
	    --
	    NEXT_ADDRESS :=
		NEXT_ADDRESS +
		ADDRESS_INT(NUMBER_OF_ITEMS_TO_BYTE_SIZE(NUMBER_OF_ITEMS));

	    -- Make sure there is enough
	    --
	    if NEXT_ADDRESS > SECTION_RANGE(1) then
		TEXT_IO.PUT_LINE("FLIGHT_RECORDER__FILE_MANAGER could not" &
		    "provide" &
		    INTEGER'image(NUMBER_OF_ITEMS_TO_BYTE_SIZE(NUMBER_OF_ITEMS))
		    & " more bytes");
		NEXT_ADDRESS := ADDRESS_ZERO;
		return null;
	    end if;

	    -- Initialise the object
	    --
	    declare
		X : TAPE_TYPE(NUMBER_OF_ITEMS);
		for X use at SYSTEM.ADDRESS(A);
	    begin
		null;
	    end;

	    -- Now return as an access type
	    --
	    return TO_ACCESS_TAPE_TYPE(A);
	end;


    begin
	for I in NUMBER_OF_ITEMS_RANGE loop
	    declare
		subtype S is TAPE_TYPE(I);
	    begin
		-- Make sure is a multiple of 4, so that alignment
		-- stays okay.
		NUMBER_OF_ITEMS_TO_BYTE_SIZE(I) := ((S'size + 31)/32)*4;
	    end;
	end loop;

	-- Create the storage
	--
	NEXT_ADDRESS := ALLOCATE_MEMORY(SECTION_SIZE);
	SECTION_RANGE(0) := NEXT_ADDRESS;
	SECTION_RANGE(1) := SECTION_RANGE(0) +
	    ADDRESS_INT(SECTION_SIZE - INTEGER'(1));

    end;
