--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with CONTROLS, SEQUENTIAL_IO;
pragma ELABORATE(SEQUENTIAL_IO);

separate(FLIGHT_RECORDER)
    package body DISK is


	FILE_NAME : constant STRING := "FCTM_FLIGHT_RECORDER";


	READER_FINISHED : BOOLEAN := FALSE;

	task READER is
	    entry START;
	    pragma PRIORITY(9);
	end;


	task WRITER is
	    entry START;
	    pragma PRIORITY(9);
	end;


	procedure START_READER is
	begin
	    if READER_STARTED then return; end if;
	    READER_STARTED := TRUE;
	    READER.START;
	end;

	procedure START_WRITER is
	begin
	    if WRITER_STARTED then return; end if;
	    WRITER_STARTED := TRUE;
	    WRITER.START;
	end;


	package IO is new SEQUENTIAL_IO(SUBFRAME_TYPE);


	task body READER is
	    F : IO.FILE_TYPE;
	    FIRST,
	    LAST,
	    NEXT	: ACCESS_TAPE_TYPE;
	    SUBFRAME	: SUBFRAME_TYPE;

	    function SEND_LIST return BOOLEAN is
	    begin
		if FRAMES_READ_FIRST /= null then return FALSE; end if;

		FRAMES_READ_LAST  := LAST;
		FRAMES_READ_FIRST := FIRST; -- must be second, since is the
					    -- flag the outside is waiting
					    -- for.
		FIRST := null;
		LAST  := null;

		return true;
	    end;

	    procedure DONE is
	    begin
		-- send our list to the other task asap
		--
		while not SEND_LIST loop delay 0.1; end loop;
		READER_FINISHED := TRUE;
	    end;

	begin
	    select
		accept START;
	    or
		terminate;
	    end select;

	    IO.OPEN (
		FILE => F,
		MODE => IO.IN_FILE,
		NAME => FILE_NAME);

	    while not CONTROLS.EXIT_PRESSED loop
		IO.READ(F, SUBFRAME);

		-- attach to our list
		--
		NEXT := FILE_MANAGER.ALLOCATE(SUBFRAME.NUMBER_OF_ITEMS);
		if NEXT = null then
		    TEXT_IO.PUT_LINE("Out of tape memory for replay");
		    DONE;
		    exit;
		end if;

		NEXT.SUBFRAME	:= SUBFRAME;
		NEXT.NEXT	:= null;
		if FIRST = null then
		    NEXT.PREV := null;
		    FIRST := NEXT;
		else
		    NEXT.PREV := LAST;
		    LAST.NEXT := NEXT;
		end if;
		LAST := NEXT;

		-- send our list out to the other task asap
		--
		if not SEND_LIST then null; end if;

	    end loop;

	exception
	    when TEXT_IO.END_ERROR => DONE;
	    when others => DONE;
		TEXT_IO.PUT_LINE("FLIGHT_RECORDER__DISK abnormally dying");

	end;


	task body WRITER is

	    F : IO.FILE_TYPE;

	    NEXT : ACCESS_TAPE_TYPE;

	begin
	    select
		accept START;
	    or
		terminate;
	    end select;

	    IO.CREATE (
		FILE => F,
		MODE => IO.OUT_FILE,
		NAME => FILE_NAME);

	    loop
		if NEXT = null then
		    NEXT := TAPE_FIRST;
		end if;

		while NEXT /= LAST_FRAME_TO_WRITE loop
		    IO.WRITE(F, NEXT.SUBFRAME);
		    NEXT := NEXT.NEXT;
		end loop;

		exit when CONTROLS.EXIT_PRESSED;

		delay 1.0;
	    end loop;

	exception
	    when others =>
		TEXT_IO.PUT_LINE("FLIGHT_RECORDER__WRITER abnormally dying");

	end;

    end;

