--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with NYI;

with ETHERNET, MESSAGE_MANAGER, SCALAR_PHYSICS;
use  ETHERNET, MESSAGE_MANAGER;

pragma ELABORATE(
    ETHERNET);

package FLIGHT_RECORDER is

    -- The following are maintained outside of this package, possibly
    -- by a different task.
    --
    type STATE_TYPE is	(OFF, ON_PLAY, ON_RECORD);

    STATE	    : STATE_TYPE    := OFF;	pragma SHARED(STATE);
    SPEED	    : INTEGER	    := 0;	pragma SHARED(SPEED);
    MARK_PRESSED    : BOOLEAN	    := FALSE;	pragma SHARED(MARK_PRESSED);


    FLIGHT_RECORDER_REMOTE_NUMBER :
	constant ETHERNET.REMOTE_NUMBER_TYPE
	:= ETHERNET.ALLOCATE_REMOTE_NUMBER;

    THIS_SIMULATOR_REMOTE_NUMBER :
	constant ETHERNET.REMOTE_NUMBER_TYPE
	:= ETHERNET.ALLOCATE_REMOTE_NUMBER;


    procedure START_NEW_FRAME(
	ELAPSED : SCALAR_PHYSICS.SECONDS;
	MARK	: BOOLEAN := FALSE);

    procedure RECORD_MESSAGE(
	MESSAGE : MESSAGE_TYPE;
	FROM	: REMOTE_NUMBER_TYPE);

    generic
	with procedure RECEIVE_AN_ITEM(
	    MESSAGE_ITEM    : in out MESSAGE_ITEM_TYPE;
	    REMOTE_NUMBER   : REMOTE_NUMBER_TYPE;
	    ORIGINAL_RN     : REMOTE_NUMBER_TYPE);
    procedure PLAY(ELAPSED : SCALAR_PHYSICS.SECONDS);

end;
