--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    CONTROLS, IS_DEMO_PKG, LOGICAL_TO_STRING,
    OBJECTS, WORLD_PHYSICS,
    GRAPHICS_WINDOW_MANAGER, INFO_MANAGER, MAIN_SIMULATION, SELECT_CRAFT, WORLD_MANAGER;

procedure FCTM is

    pragma PRIORITY(8);

    PRESELECTED_ENTRY_POINT : constant STRING
	:= LOGICAL_TO_STRING("FCTM_ENTRY_POINT", "");

    PRESELECTED_CRAFT : constant STRING
	:= LOGICAL_TO_STRING("FCTM_CRAFT", "");

    PRESELECTED_SUBCLASS : constant STRING
	:= LOGICAL_TO_STRING("FCTM_SUBCLASS", "");

    procedure MAKE_CHOICE is
	new SELECT_CRAFT.CHOOSE(GRAPHICS_WINDOW_MANAGER.SELECT_FROM_MENU);
	pragma INLINE_GENERIC(MAKE_CHOICE);

    procedure CREATE(
	ENTRY_CHOICE,
	CLASS_CHOICE,
	SUBCLASS_CHOICE : STRING)
    is
	CLASS		: OBJECTS.CLASS_TYPE;
	SUBCLASS_KEY    : INTEGER;
	LOCATION	: OBJECTS.OBJECT_LOCATION;
	ORIENTATION     : WORLD_PHYSICS.POSITION_BASIS;
	VELOCITY	: WORLD_PHYSICS.VELOCITY;
    begin
	MAKE_CHOICE(CLASS, SUBCLASS_KEY, LOCATION, ORIENTATION, VELOCITY,
	    ENTRY_CHOICE, CLASS_CHOICE, SUBCLASS_CHOICE);
	MAIN_SIMULATION.OBJECT_SYNC.ADD_OBJECT(
	    CLASS, INFO_MANAGER.SUBCLASS_TYPE(SUBCLASS_KEY),
	    LOCATION, ORIENTATION, VELOCITY,
	    MAINTAINER => OBJECTS.THIS_SIMULATOR,
	    CONTROLLED => TRUE);
    end;

begin
    -- Create the world and its contained objects
    --
    WORLD_MANAGER.CREATE;

    -- Demo support
    --
    if IS_DEMO_PKG.IS_DEMO then
	CREATE(
	    "10 miles north. 30,000 ft+",
	    "AEROPLANE",
	    "F-4");
	CREATE(
	    "10 miles south. 30,000 ft+",
	    "MAGIC_CARPET",
	    "");
	IS_DEMO_PKG.START_DEMO;
    end if;

    -- Keep selecting and flying craft
    --
    loop
	-- Select a craft, unless a demo in which case the magic carpet keeps
	-- going...
	--
	if not IS_DEMO_PKG.IS_DEMO then
	    CREATE(
		PRESELECTED_ENTRY_POINT,
		PRESELECTED_CRAFT,
		PRESELECTED_SUBCLASS);
	end if;

	-- Control it, until done
	--
	MAIN_SIMULATION.OBJECT_SYNC.SELECT_NEW_CONTROLLED_OBJECT;

    end loop;

    -- exceptions are used to terminate the simulation
    --
exception
    when others =>
	if not CONTROLS.EXIT_PRESSED then
	    raise;
	end if;

end;
