--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with SYSTEM;
package ETHERNET_IO is

    PROTOCOL : constant := 16#0660#;
	-- This is also hard coded into OSF1_ETHERNET_IO_IMPLEMENTATION.C

    type ETHERNET_PHYSICAL_ADDRESS_TYPE is
	array(1..6) of INTEGER range 0..255;
	pragma PACK(ETHERNET_PHYSICAL_ADDRESS_TYPE);
	for ETHERNET_PHYSICAL_ADDRESS_TYPE'size use 48;

    type PACKET_HEADER_INFORMATION_TYPE is
	record
	    DESTINATION : ETHERNET_PHYSICAL_ADDRESS_TYPE;
	    SOURCE	: ETHERNET_PHYSICAL_ADDRESS_TYPE;
	    PROTOCOL	: INTEGER range 0..2**16-1;
	end record;
	for PACKET_HEADER_INFORMATION_TYPE'size use 14*8;
	for PACKET_HEADER_INFORMATION_TYPE use
	record
	    DESTINATION at 0 range 0..6*8-1;
	    SOURCE	at 6 range 0..6*8-1;
	    PROTOCOL	at 12 range 0..15;
	end record;

    type IO_STATUS_TYPE is private;
    procedure INIT_AS_OKAY(IO_STATUS	: in out IO_STATUS_TYPE);

    type CHANNEL_TYPE   is private;
    procedure ASSIGN(CHANNEL		: in out CHANNEL_TYPE);
    procedure STARTUP(CHANNEL		: in out CHANNEL_TYPE);
    function GET_ETHERNET_PHYSICAL_ADDRESS(CHANNEL : CHANNEL_TYPE)
	return ETHERNET_PHYSICAL_ADDRESS_TYPE;

    procedure SYNC_AND_WRITE(
	IO_STATUS   : in IO_STATUS_TYPE;
	CHANNEL     : in CHANNEL_TYPE;
	NUM_BYTES   : in NATURAL;
	BYTES	    : in SYSTEM.ADDRESS;
	DESTINATION : in ETHERNET_PHYSICAL_ADDRESS_TYPE);

    function DID_READ_NOW(
	IO_STATUS   : in IO_STATUS_TYPE;
	CHANNEL     : in CHANNEL_TYPE;
	NUM_BYTES   : in NATURAL;
	BYTES       : in SYSTEM.ADDRESS;
	PKT_HEAD    : in SYSTEM.ADDRESS) return BOOLEAN;

private
    type REAL_CHANNEL_TYPE;
    type REAL_IO_STATUS_TYPE;
    type CHANNEL_TYPE   is access REAL_CHANNEL_TYPE;
    type IO_STATUS_TYPE is access REAL_IO_STATUS_TYPE;
end;
