--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


separate(ETHERNET)
    package body GENERIC_TRANSCEIVER is

	INPUT_CHANNEL : ACCESS_INPUT_CHANNEL_TYPE;

	procedure TRANSMIT(
	    DESTINATION	    : ACCESS_OUTPUT_CHANNEL_TYPE;
	    MESSAGE 	    : MESSAGE_TYPE
	    ) is

	begin
	    if NEXT_ASYNCH_IOSB = ASYNCH_IOSBS'last then
		NEXT_ASYNCH_IOSB := ASYNCH_IOSBS'first;
	    else
		NEXT_ASYNCH_IOSB := NEXT_ASYNCH_IOSB + 1;
	    end if;

	    SYNC_AND_WRITE(
		ASYNCH_IOSBS(NEXT_ASYNCH_IOSB),
		CHANNEL,
		(MESSAGE'size+7)/8,
		MESSAGE'address,
		DESTINATION.DESTINATION);
	end;

	procedure START_RECEIVING(INPUT_CHANNEL : ACCESS_INPUT_CHANNEL_TYPE) is
	begin
	    GENERIC_TRANSCEIVER.INPUT_CHANNEL := INPUT_CHANNEL;
	end;

	procedure RECEIVE_ALL_PENDING is
	    BUFFER	    : MESSAGE_TYPE; pragma VOLATILE(BUFFER);
	    REMOTE_NUMBER   : REMOTE_NUMBER_TYPE;
	    WAS_DEFINED     : BOOLEAN;
	begin
	    while DID_READ_NOW(
			SYNCH_IOSB,
			CHANNEL,
			(BUFFER'size+7)/8,
			BUFFER'address,
			INPUT_CHANNEL.PKT_HEAD'address)
	    loop
		TO_REMOTE_NUMBER_TYPE(INPUT_CHANNEL.PKT_HEAD.SOURCE,
		    FALSE, REMOTE_NUMBER, WAS_DEFINED);
		if WAS_DEFINED then
		    RECEIVE(BUFFER, REMOTE_NUMBER);
		end if;
	    end loop;
	end;

	procedure STOP_RECEIVING is
	begin
	    GENERIC_TRANSCEIVER.INPUT_CHANNEL := null;
	end;

    end;
