--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


package ETHERNET is

    type ACCESS_INPUT_CHANNEL_TYPE is private;
    type ACCESS_OUTPUT_CHANNEL_TYPE is private;

    type ETHERNET_ADDRESS_TYPE is new STRING;
    type REMOTE_NUMBER_TYPE is new POSITIVE;


    MAX_MESSAGE_TYPE_SIZE : constant := 1490*8;


    REMOTE_NUMBER_ERROR : exception;

    function TO_ETHERNET_ADDRESS_TYPE(
	REMOTE_NUMBER : REMOTE_NUMBER_TYPE)
	return ETHERNET_ADDRESS_TYPE;

    procedure TO_REMOTE_NUMBER_TYPE(
	ETHERNET_ADDRESS    : ETHERNET_ADDRESS_TYPE;
	ADD_IF_NOT_DEFINED  : in BOOLEAN;
	REMOTE_NUMBER	    : out REMOTE_NUMBER_TYPE;
	WAS_DEFINED	    : out BOOLEAN);

    function ALLOCATE_REMOTE_NUMBER
	return REMOTE_NUMBER_TYPE;


    OPEN_ERROR : exception;

    function OPEN
	return ACCESS_INPUT_CHANNEL_TYPE;

    CREATE_ERROR : exception;

    function CREATE(
	ETHERNET_ADDRESS    : ETHERNET_ADDRESS_TYPE)
	return ACCESS_OUTPUT_CHANNEL_TYPE;


    generic
	type MESSAGE_TYPE is private;

	with procedure RECEIVE(
		MESSAGE 	: in out MESSAGE_TYPE;
		REMOTE_NUMBER	: REMOTE_NUMBER_TYPE);

    package GENERIC_TRANSCEIVER is

	procedure TRANSMIT(
	    DESTINATION	    : ACCESS_OUTPUT_CHANNEL_TYPE;
	    MESSAGE 	    : MESSAGE_TYPE
	    );

	procedure START_RECEIVING(INPUT_CHANNEL : ACCESS_INPUT_CHANNEL_TYPE);
	procedure RECEIVE_ALL_PENDING;
	procedure STOP_RECEIVING;
    end;


    procedure CLOSE(
	INPUT_CHANNEL	    : in out ACCESS_INPUT_CHANNEL_TYPE);
	
    procedure CLOSE(
	OUTPUT_CHANNEL	    : in out ACCESS_OUTPUT_CHANNEL_TYPE);


private

    type INPUT_CHANNEL_TYPE;
    type OUTPUT_CHANNEL_TYPE;

    type ACCESS_INPUT_CHANNEL_TYPE is access INPUT_CHANNEL_TYPE;
    type ACCESS_OUTPUT_CHANNEL_TYPE is access OUTPUT_CHANNEL_TYPE;

end;
