--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


generic
    type SOME_FLOAT is digits <>;
    type SCALE_TYPE is digits <>;
    with function "*"(LEFT : SOME_FLOAT; RIGHT : SCALE_TYPE) return SOME_FLOAT
	is <>;
package DIGITS_VECTOR is

    type VECTOR is record I,J,K : SOME_FLOAT; end record;
	for VECTOR use record at mod 4; end record;
    subtype UNIT_VECTOR is VECTOR;			    -- length 1.0

    function "+"(RIGHT : VECTOR) return VECTOR;
    function "-"(RIGHT : VECTOR) return VECTOR;

    function "+"(LEFT,RIGHT : VECTOR) return VECTOR;
    function "-"(LEFT,RIGHT : VECTOR) return VECTOR;

    function "*"(LEFT,RIGHT : VECTOR) return VECTOR;	    -- cross product
    function "&"(LEFT,RIGHT : VECTOR) return SOME_FLOAT;    -- dot product

    function "*"(LEFT : VECTOR;     RIGHT : INTEGER)	return VECTOR;
    function "*"(LEFT : INTEGER;    RIGHT : VECTOR)	return VECTOR;
    function "*"(LEFT : VECTOR;     RIGHT : SCALE_TYPE) return VECTOR;
    function "*"(LEFT : SCALE_TYPE; RIGHT : VECTOR)	return VECTOR;

    function "/"(LEFT : VECTOR;     RIGHT : SCALE_TYPE)	return VECTOR;

    function TO_UNIT_VECTOR(RIGHT : VECTOR) return VECTOR;
    function LENGTH(RIGHT : VECTOR) return SOME_FLOAT;

    procedure ADD	(LEFT : VECTOR;     RIGHT : in VECTOR;
	NON_OVERLAPPING_RESULT : out VECTOR);

    procedure ADD	(LEFT : VECTOR;     RIGHT : in out VECTOR);
    procedure SUBTRACT	(LEFT : VECTOR;     RIGHT : in out VECTOR);
    procedure MULTIPLY	(LEFT : INTEGER;    RIGHT : in out VECTOR);
    procedure MULTIPLY	(LEFT : SCALE_TYPE; RIGHT : in out VECTOR);
    procedure DIVIDE	(LEFT : SCALE_TYPE; RIGHT : in out VECTOR);
    procedure CROSS	(LEFT : VECTOR;     RIGHT : in out VECTOR);

    procedure MAKE_UNIT_VECTOR(LEFT : VECTOR; RIGHT : out VECTOR);
    procedure MAKE_UNIT_VECTOR(RIGHT : in out VECTOR);

    procedure PROJECT	(ORIGIN 	: VECTOR;
			 I,J,K		: UNIT_VECTOR;
			 FROM		: VECTOR;
			 PROJECTION_I,
			 PROJECTION_J,
			 PROJECTION_K	: out SOME_FLOAT);

    procedure PROJECT_SAME_ORIGIN(
			 I,J,K		: UNIT_VECTOR;
			 FROM		: VECTOR;
			 PROJECTION_I,
			 PROJECTION_J,
			 PROJECTION_K	: out SOME_FLOAT);

private
    pragma INLINE("+","-","*","/","&",TO_UNIT_VECTOR,LENGTH,
		    ADD,SUBTRACT,MULTIPLY,DIVIDE,CROSS,MAKE_UNIT_VECTOR,
		    PROJECT, PROJECT_SAME_ORIGIN);

end;
