--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with VIEW_DIRECTION_CONTROL;
package CONTROLS is

    type STICK_LEFT_RIGHT_TYPE	    is digits 3 range -1.0 .. 1.0;
    type STICK_FORWARD_BACK_TYPE    is digits 3 range -1.0 .. 1.0;
    type FLAP_TYPE		    is range   0..50;
    type RUDDER_TYPE		    is range -10..10;
    type THROTTLE_TYPE		    is range   0..50;
    type MODE_TYPE		    is range   0.. 3;

    subtype MESSAGE_LENGTH_SUBTYPE  is NATURAL range 0..80;
    subtype MESSAGE_SUBTYPE	    is STRING(1..MESSAGE_LENGTH_SUBTYPE'last);

    -- The following are maintained asynchronously
    --
    EXIT_PRESSED    : BOOLEAN		    := FALSE;

    -- All the above variables are shared between tasks
    --
    pragma SHARED(EXIT_PRESSED);


    type CONTROL_SETTING_TYPE is
	record
	    STICK_LEFT_RIGHT	: STICK_LEFT_RIGHT_TYPE     := 0.0;
	    STICK_FORWARD_BACK	: STICK_FORWARD_BACK_TYPE   := 0.0;
	    FLAP		: FLAP_TYPE		    := 0;
	    RUDDER		: RUDDER_TYPE		    := 0;
	    THROTTLE		: THROTTLE_TYPE 	    := 0;
	    AFTERBURNER_ON	: BOOLEAN		    := FALSE;
	    SIGHT_ON		: BOOLEAN		    := TRUE;
	    MODE		: MODE_TYPE		    := 0;

	    VD_CONTROL		: VIEW_DIRECTION_CONTROL.CONTROL_TYPE
				:= (CONTROL_STATE=>
					VIEW_DIRECTION_CONTROL.UNCHANGED);

	    TRIGGER1_PRESSED	: BOOLEAN		    := FALSE;
	    TRIGGER2_PRESSED	: BOOLEAN		    := FALSE;
	    TRIGGER1_RELEASED	: BOOLEAN		    := FALSE;
	    TRIGGER2_RELEASED	: BOOLEAN		    := FALSE;

	    CHANGE_PRESSED	: BOOLEAN		    := FALSE;
	    QUIT_PRESSED	: BOOLEAN		    := FALSE;
	    MESSAGE_LENGTH	: MESSAGE_LENGTH_SUBTYPE    := 0;
	    MESSAGE_TEXT	: MESSAGE_SUBTYPE;
	end record;

    type CONTROL_SETTING_LIMIT_TYPE is
	record
	    STICK_LEFT_RIGHT	: STICK_LEFT_RIGHT_TYPE;
	    STICK_FORWARD_BACK	: STICK_FORWARD_BACK_TYPE;
	    FLAP		: FLAP_TYPE;
	    RUDDER		: RUDDER_TYPE;
	    THROTTLE		: THROTTLE_TYPE;
	    AFTERBURNER_ON	: BOOLEAN;
	end record;

    MIN_CONTROL_SETTING : constant CONTROL_SETTING_LIMIT_TYPE := (
	    STICK_LEFT_RIGHT	=> STICK_LEFT_RIGHT_TYPE'first,
	    STICK_FORWARD_BACK	=> STICK_FORWARD_BACK_TYPE'first,
	    FLAP		=> FLAP_TYPE'first,
	    RUDDER		=> RUDDER_TYPE'first,
	    THROTTLE		=> THROTTLE_TYPE'first,
	    AFTERBURNER_ON	=> BOOLEAN'first
	    );

    MAX_CONTROL_SETTING : constant CONTROL_SETTING_LIMIT_TYPE := (
	    STICK_LEFT_RIGHT	=> STICK_LEFT_RIGHT_TYPE'last,
	    STICK_FORWARD_BACK	=> STICK_FORWARD_BACK_TYPE'last,
	    FLAP		=> FLAP_TYPE'last,
	    RUDDER		=> RUDDER_TYPE'last,
	    THROTTLE		=> THROTTLE_TYPE'last,
	    AFTERBURNER_ON	=> BOOLEAN'last
	    );

end;
