--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with SCALAR_PHYSICS, WORLD_PHYSICS;
package COMPRESSED_ORIENTATION_MANAGER is

    type COMPRESSED_ORIENTATION_TYPE is private;

    procedure COMPRESS(
	ORIENTATION	: WORLD_PHYSICS.POSITION_BASIS;
	COMPRESSED	: out COMPRESSED_ORIENTATION_TYPE);
    pragma INLINE(COMPRESS);

    procedure DECOMPRESS(
	COMPRESSED	: COMPRESSED_ORIENTATION_TYPE;
	ORIENTATION	: in out WORLD_PHYSICS.POSITION_BASIS);
    pragma INLINE(DECOMPRESS);

private
    CRTS : constant INTEGER := 14;	-- COMPRESSED_RATIO_TYPE'size
    CVTS : constant INTEGER := 32;	-- COMPRESSED_VECTOR_TYPE'size
    COTS : constant INTEGER := CVTS*2;  -- COMPRESSED_ORIENTATION_TYPE'size

    type COMPRESSED_RATIO_TYPE is
	delta 2.0**(1-CRTS) range -1.0 .. 1.0;
	for COMPRESSED_RATIO_TYPE'size use CRTS;

    type AXIS_TYPE is (AXIS_I, AXIS_J, AXIS_K);

    type COMPRESSED_VECTOR_TYPE is
	record
	    AXIS	    : AXIS_TYPE;
	    AXIS_POSITIVE   : BOOLEAN;
	    RATIO_1,
	    RATIO_2 : COMPRESSED_RATIO_TYPE;
	end record;
	for COMPRESSED_VECTOR_TYPE'size use CVTS;
	for COMPRESSED_VECTOR_TYPE use
	record
	    AXIS	    at 0 range 0..1;
	    AXIS_POSITIVE   at 0 range 2..2;
	    RATIO_1	    at 0 range 3+0*CRTS..3+1*CRTS-1;
	    RATIO_2	    at 0 range 3+1*CRTS..CVTS-1;
	end record;

    type COMPRESSED_ORIENTATION_TYPE is
	record
	    I,J : COMPRESSED_VECTOR_TYPE;
	end record;
	for COMPRESSED_ORIENTATION_TYPE'size use COTS;
	for COMPRESSED_ORIENTATION_TYPE use
	record
	    I		    at 0 range  0*CVTS.. 1*CVTS-1;
	    J		    at 0 range  1*CVTS.. 2*CVTS-1;
	end record;

end;
