--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with SCALE_TYPE_MATH_LIB, TEXT_IO, FLOAT_TEXT_IO;

package body COMPRESSED_ORIENTATION_MANAGER is
    use SCALAR_PHYSICS, WORLD_PHYSICS;

    ALMOST_ONE : constant SCALE_TYPE := 0.9999;
	-- Tad less than 1.0 to avoid the possibility that the RATIO
	-- in DO_COMPRESS be a tad bigger than 1.0!

    procedure COMPRESS(
	V		: WORLD_PHYSICS.POSITION;
	CV		: out COMPRESSED_VECTOR_TYPE) is

	I		: SCALE_TYPE := SCALE_TYPE(V.I);
	J		: SCALE_TYPE := SCALE_TYPE(V.J);
	K		: SCALE_TYPE := SCALE_TYPE(V.K);

	procedure DO_COMPRESS(
	    AXIS    : AXIS_TYPE;
	    AXIS_V  : SCALE_TYPE;
	    DENOM_1 : SCALE_TYPE;
	    DENOM_2 : SCALE_TYPE) is

	    INV_NUMERATOR : SCALE_TYPE := (ALMOST_ONE/(abs AXIS_V));
	begin
	    CV.AXIS := AXIS;
	    CV.AXIS_POSITIVE := (AXIS_V > 0.0);
	    CV.RATIO_1 := COMPRESSED_RATIO_TYPE(DENOM_1*INV_NUMERATOR);
	    CV.RATIO_2 := COMPRESSED_RATIO_TYPE(DENOM_2*INV_NUMERATOR);
	end;

    begin
	if abs I > abs J then
	    if abs K > abs I then
		DO_COMPRESS(AXIS_K, K, I, J);
	    else
		DO_COMPRESS(AXIS_I, I, J, K);
	    end if;
	else
	    if abs K > abs J then
		DO_COMPRESS(AXIS_K, K, I, J);
	    else
		DO_COMPRESS(AXIS_J, J, I, K);
	    end if;
	end if;
    exception
	when others =>
	    TEXT_IO.PUT_LINE("COMPRESSED_ORIENTATION_MANAGER.COMPRESS failed");

	    TEXT_IO.PUT("(");
	    FLOAT_TEXT_IO.PUT(FLOAT(V.I)); TEXT_IO.PUT(',');
            FLOAT_TEXT_IO.PUT(FLOAT(V.J)); TEXT_IO.PUT(',');
            FLOAT_TEXT_IO.PUT(FLOAT(V.K)); TEXT_IO.PUT(')');
            TEXT_IO.PUT_LINE(")");

	    CV := (AXIS_I, TRUE, 0.0, 0.0);
    end;

    procedure COMPRESS(
	ORIENTATION	: WORLD_PHYSICS.POSITION_BASIS;
	COMPRESSED	: out COMPRESSED_ORIENTATION_TYPE) is
    begin
	COMPRESS(ORIENTATION.I, COMPRESSED.I);
	COMPRESS(ORIENTATION.J, COMPRESSED.J);
    end;


    procedure DECOMPRESS(
	CV		: COMPRESSED_VECTOR_TYPE;
        V		: out WORLD_PHYSICS.POSITION) is

        TV : WORLD_PHYSICS.POSITION;

        procedure DO_DECOMPRESS(M1, M2, M3 : out METRES) is
        begin
	    if CV.AXIS_POSITIVE then
		M1 := METRES(ALMOST_ONE);
	    else
		M1 := -METRES(ALMOST_ONE);
	    end if;
	    M2 := METRES(CV.RATIO_1);
	    M3 := METRES(CV.RATIO_2);
        end;

    begin
	case CV.AXIS is
	    when AXIS_I => DO_DECOMPRESS(TV.I, TV.J, TV.K);
	    when AXIS_J => DO_DECOMPRESS(TV.J, TV.I, TV.K);
	    when AXIS_K => DO_DECOMPRESS(TV.K, TV.I, TV.J);
	end case;
	MAKE_UNIT_VECTOR(TV, V);
    exception
	when others =>
	    TEXT_IO.PUT_LINE("COMPRESSED_ORIENTATION_MANAGER.DECOMPRESS failed");
	    V := (1.0, 0.0, 0.0);
    end;

    procedure DECOMPRESS(
	COMPRESSED	: COMPRESSED_ORIENTATION_TYPE;
	ORIENTATION	: in out WORLD_PHYSICS.POSITION_BASIS) is
    begin
	DECOMPRESS(COMPRESSED.I, ORIENTATION.I);
	DECOMPRESS(COMPRESSED.J, ORIENTATION.J);
	--ORIENTATION.K := ORIENTATION.J;
	--CROSS(ORIENTATION.I, ORIENTATION.K);
	declare
	    I_I : constant METRES := ORIENTATION.I.I;
	    I_J : constant METRES := ORIENTATION.I.J;
	    I_K : constant METRES := ORIENTATION.I.K;
	    J_I : constant METRES := ORIENTATION.J.I;
	    J_J : constant METRES := ORIENTATION.J.J;
	    J_K : constant METRES := ORIENTATION.J.K;
	begin
	    ORIENTATION.K.I := (I_J*J_K)-(I_K*J_J);
	    ORIENTATION.K.J := (I_K*J_I)-(I_I*J_K);
	    ORIENTATION.K.K := (I_I*J_J)-(I_J*J_I);
	end;
    end;

end;
