--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with TEXT_IO, FLOAT_TEXT_IO, WORLD_PHYSICS;
use  TEXT_IO, FLOAT_TEXT_IO;
package body COLLISION_DUMP is
    use OBJECTS;

    F : FILE_TYPE;

    procedure PUT_L(O : OBJECT_LOCATION) is
    begin
	PUT(F, "( ");	PUT(F, FLOAT(O.I));
	PUT(F, ", ");	PUT(F, FLOAT(O.J));
	PUT(F, ", ");	PUT(F, FLOAT(O.K));
	PUT(F, ")");
    end;

    procedure PUT_P(O : WORLD_PHYSICS.POSITION) is
    begin
	PUT(F, "(");	PUT(F, FLOAT(O.I));
	PUT(F, ", ");	PUT(F, FLOAT(O.J));
	PUT(F, ", ");	PUT(F, FLOAT(O.K));
	PUT(F, ")");
    end;

    procedure PUT_INFO(O : OBJECTS.OBJECT_TYPE) is
    begin
	PUT(F, " maintainer = " & MAINTAINER_TYPE'image(O.MAINTAINER));  NEW_LINE(F);
	PUT(F, " location   = "); PUT_L(O.LOCATION);		    NEW_LINE(F);
	PUT(F, " old locat  = "); PUT_L(O.OLD_LOCATION);	    NEW_LINE(F);
	PUT(F, " orient.i   = "); PUT_P(O.ORIENTATION.I);	    NEW_LINE(F);
	PUT(F, " orient.j   = "); PUT_P(O.ORIENTATION.J);	    NEW_LINE(F);
	PUT(F, " orient.k   = "); PUT_P(O.ORIENTATION.K);	    NEW_LINE(F);
    end;

    procedure DUMP(O1, O2 : OBJECTS.OBJECT_TYPE) is
    begin
	PUT_LINE(F, "collision between" &
		    CLASS_TYPE'image(O1.CLASS) & " " &
		    CLASS_TYPE'image(O2.CLASS));
	PUT_LINE(F, "First was at");   PUT_INFO(O1);
	PUT_LINE(F, "Second was at");  PUT_INFO(O2);
    end;

begin
    if ENABLED then
	CREATE (
	    FILE => F,
	    MODE => OUT_FILE,
	    NAME => "FCTM_COLLISION.DAT");
    end if;
end;
