--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with OBJECTS, SCALAR_PHYSICS;
use  OBJECTS, SCALAR_PHYSICS;

pragma ELABORATE(OBJECTS, SCALAR_PHYSICS);

function CLOSEST_APPROACH(A0, A1, B0, B1 : OBJECT_LOCATION) return SCALE_TYPE is

    D0_I, D0_J, D0_K		: SCALE_TYPE;
    D1_I, D1_J, D1_K		: SCALE_TYPE;
    COEFF_A, COEFF_B, COEFF_C	: SCALE_TYPE;
    T				: SCALE_TYPE;

begin

    --The distance vector at time T is
    --		(1-T)(A0-B0)+T(A1-B1)
    --	    =   (A0-B0)+T*[(A1-B1)-(A0-B0)]
    --	    =   D0 + T*D1
    --
    D0_I := SCALE_TYPE(A0.I - B0.I);
    D0_J := SCALE_TYPE(A0.J - B0.J);
    D0_K := SCALE_TYPE(A0.K - B0.K);

    D1_I := SCALE_TYPE(A1.I - B1.I) - D0_I;
    D1_J := SCALE_TYPE(A1.J - B1.J) - D0_J;
    D1_K := SCALE_TYPE(A1.K - B1.K) - D0_K;

    --The length of this vector at time T is
    --		sqrt(sum(I,J,K)(D0.i+tD1.i)**2)
    --	    =   aT**2 + b*T + c
    --
    COEFF_A := D1_I**2 + D1_J**2 + D1_K**2;
    COEFF_B := 2.0*(D0_I*D1_I + D0_J*D1_J + D0_K*D1_K);
    COEFF_C := D0_I**2 + D0_J**2 + D0_K**2;

    -- The minimum for this is at 2*aT + b = 0   =>  T = -(b/(2*a)), if
    -- A is very small this could overflow, which would happen if the
    -- lines where parallel, in which case it doesn't really matter
    -- which T is chosen, so choose 0.5.  If the minima occurs outside
    -- 0..1, then choose then end it is closest too.
    --
    T := 0.5;
    if COEFF_A > COEFF_B/100.0 then
	T := -(COEFF_B / (2.0*COEFF_A));
	if T > 1.0 then T := 1.0; end if;
	if T < 0.0 then T := 0.0; end if;
    end if;

    -- Return the square of the minimum distance
    --
    return (COEFF_A*T + COEFF_B)*T + COEFF_C;
end;
