--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with INTEGER_MIN;
pragma ELABORATE(INTEGER_MIN);

package body CHARACTER_UTILITIES is

    function ALL_SPACES_OR_TABS(LHS : STRING) return BOOLEAN is
    begin
	for I in LHS'range loop
	    if LHS(I) /= ' ' and LHS(I) /= ASCII.HT then return FALSE; end if;
	end loop;
	return TRUE;
    end;

    function UPPER_CASE(LHS : CHARACTER) return CHARACTER is
    begin
	if LHS not in 'a'..'z' then return LHS; end if;
	return
	    CHARACTER'val(
		CHARACTER'pos(LHS)-
		CHARACTER'pos('a')+
		CHARACTER'pos('A'));
    end;

    function SOMEWHAT_EQUAL(LHS, RHS : CHARACTER) return BOOLEAN is
    begin
	return UPPER_CASE(LHS) = UPPER_CASE(RHS);
    end;

    function SOMEWHAT_EQUAL(LHS, RHS : STRING) return BOOLEAN is
	-- Return true if equal apart from case and trailing spaces
	LAST_I	: NATURAL := INTEGER_MIN(LHS'length, RHS'length);
    begin
	for I in 0..LAST_I-1 loop
	    if not SOMEWHAT_EQUAL(LHS(LHS'first+I), RHS(RHS'first+I)) then
		return false;
	    end if;
	end loop;
	return  ALL_SPACES_OR_TABS(LHS(LHS'first+LAST_I..LHS'last))
	    and ALL_SPACES_OR_TABS(RHS(RHS'first+LAST_I..RHS'last));
    end;

end;
