--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    MOVE_UTILITIES, PHYSICAL_UNITS;

pragma ELABORATE(
    MOVE_UTILITIES, PHYSICAL_UNITS);

separate(BULLETS)
    procedure MOVE( O	: in out OBJECTS.OBJECT_TYPE;
		    ELAPSED_SINCE_LAST_MOVE	: SCALAR_PHYSICS.SECONDS) is
	use OBJECTS, WORLD_PHYSICS;

	L   : OBJECTS.OBJECT_LOCATION := O.LOCATION;
	V   : WORLD_PHYSICS.VELOCITY renames O.VELOCITY;
	T   : SCALAR_PHYSICS.SECONDS := ELAPSED_SINCE_LAST_MOVE;
    begin
	-- If not already hit the ground...
	--
	if (L.K >= 0.0) or (V.K > 0.0) then

	    V.K := V.K + METRES_PER_SECOND_SQUARED(PHYSICAL_UNITS.G)*T;
	    MOVE_UTILITIES.ADD_MOVEMENT_TO_LOCATION(V*T, L);

	    if O.LOCATION.K > 0.0 and L.K <= 0.0 then
		-- burrowed into the ground...
		--
		T := T*(SCALE_TYPE(O.LOCATION.K)/
			SCALE_TYPE(O.LOCATION.K-L.K));
		MOVE_UTILITIES.ADD_MOVEMENT_TO_LOCATION(V*T, O.LOCATION);
		O.LOCATION.K := 0.0;
	    else
		-- still flying
		--
		O.LOCATION := L;
	    end if;
	end if;

	-- Approx. enough to slow it down to 50% of initial speed
	-- in about 2 seconds.  Even do this after ground contact just so
	-- they go away after a while.
	--
	MULTIPLY(1.0-SCALE_TYPE(T)/6.0, V);

	-- Delete when they are too slow
	--
	if V.I**2 + V.J**2 + V.K**2 < SLOWEST_BULLET_SPEED then
	    O.DELETE_PENDING := TRUE;
	end if;
    end;
