--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


separate(BULLETS)
    procedure CREATED(
	O		: in out OBJECTS.OBJECT_TYPE)
    is
	use WORLD_PHYSICS;

	LEAD : constant SCALE_TYPE := 20.0 + SCALE_TYPE(BULLET_RADIUS);

	START_LOCATION	: OBJECTS.OBJECT_LOCATION renames O.LOCATION;

    begin
	-- Start it some distance ahead of the firing plane...,
	-- so that it won't hit the firing plane!
	--
	START_LOCATION.I := START_LOCATION.I + OBJECT_LOCATION_COORDINATE(
						O.ORIENTATION.J.I*LEAD);
	START_LOCATION.J := START_LOCATION.J + OBJECT_LOCATION_COORDINATE(
						O.ORIENTATION.J.J*LEAD);
	START_LOCATION.K := START_LOCATION.K + OBJECT_LOCATION_COORDINATE(
						O.ORIENTATION.J.K*LEAD);

	O.OLD_LOCATION := START_LOCATION;

	O.VELOCITY := O.VELOCITY +
		(O.ORIENTATION.J*SCALE_TYPE(INITIAL_AIRSPEED))
		/SCALAR_PHYSICS.SECONDS'(1.0);

	O.APPEARANCE_INFO := BULLET_APPEARANCE_INFO;

	O.RADIUS := INITIAL_AIRSPEED*SCALAR_PHYSICS.SECONDS'(0.03);

	-- three bullets per iteration, to get the density of the bullet
	-- stream about right.
	--
	O.EXTRA_RADII(1).RADIUS := BULLET_RADIUS;
	O.EXTRA_RADII(1).ORIGIN := (0.0, 0.0, 0.0);

	O.EXTRA_RADII(2).RADIUS := BULLET_RADIUS;
	O.EXTRA_RADII(2).ORIGIN := (0.0, INITIAL_AIRSPEED*SCALAR_PHYSICS.SECONDS'(0.03), 0.0);

	O.EXTRA_RADII(3).RADIUS := BULLET_RADIUS;
	O.EXTRA_RADII(3).ORIGIN := (0.0, INITIAL_AIRSPEED*SCALAR_PHYSICS.SECONDS'(0.06), 0.0);

    end;
