--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    APPEARANCE_MANAGER, INFO_MANAGER,
    WORLD_PHYSICS, OBJECT_PHYSICS, OBJECTS, SCALAR_PHYSICS;

use
    SCALAR_PHYSICS,
    APPEARANCE_MANAGER,
    OBJECTS;

pragma ELABORATE(
    SCALAR_PHYSICS, APPEARANCE_MANAGER, INFO_MANAGER);

package BULLETS is

    BULLET_APPEARANCE_INFO
	: constant INFO_MANAGER.APPEARANCE_INFO_TYPE
        := APPEARANCE_MANAGER.CREATE(
		APPEARANCE_MANAGER.PREALLOCATED_APPEARANCES_PKG.BULLETS);

    BULLET_APPEARANCE_FROM_TAPE_INFO
	: constant INFO_MANAGER.APPEARANCE_INFO_TYPE
        := APPEARANCE_MANAGER.CREATE(
		APPEARANCE_MANAGER.PREALLOCATED_APPEARANCES_PKG.BULLETS);

    procedure CREATED(
	O		: in out OBJECTS.OBJECT_TYPE);

    procedure ABOUT_TO_DELETE(O : in out OBJECTS.OBJECT_TYPE);

    procedure MOVE( O	: in out OBJECTS.OBJECT_TYPE;
		    ELAPSED_SINCE_LAST_MOVE	: SCALAR_PHYSICS.SECONDS);

    function FLIGHT_TIME(D : SCALAR_PHYSICS.METRES)
    return SCALAR_PHYSICS.SECONDS;

end;
