--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    SUBCLASS_INFO_GENERIC_PKG,
    LOGICAL_TO_FLOAT;

pragma ELABORATE(
    SUBCLASS_INFO_GENERIC_PKG,
    LOGICAL_TO_FLOAT);

package body BULLETS is

    BULLET_APPEARANCE
	: constant APPEARANCE_MANAGER.ACCESS_APPEARANCE_TYPE
        := APPEARANCE_MANAGER.TO_ACCESS_APPEARANCE_TYPE(
		BULLET_APPEARANCE_INFO);

    BULLET_APPEARANCE_FROM_TAPE
	: constant APPEARANCE_MANAGER.ACCESS_APPEARANCE_TYPE
        := APPEARANCE_MANAGER.TO_ACCESS_APPEARANCE_TYPE(
		BULLET_APPEARANCE_FROM_TAPE_INFO);

    BULLET_RADIUS : constant METRES
	:= METRES(LOGICAL_TO_FLOAT("FCTM_BULLET_RADIUS", 0.01));

    INITIAL_AIRSPEED : constant SCALAR_PHYSICS.METRES_PER_SECOND := 1_000.0;

    SLOWEST_BULLET_SPEED : constant METRES_PER_SECOND
	:= (INITIAL_AIRSPEED**2)*SCALE_TYPE'(0.5);

    AVERAGE_AIRSPEED : constant METRES_PER_SECOND
	:= (INITIAL_AIRSPEED)*SCALE_TYPE'(0.90);


    type BULLET_STATUS_TYPE is
	record
	    null;
	end record;


    type ACCESS_BULLET_STATUS_TYPE is access BULLET_STATUS_TYPE;

    package SUBCLASS_INFO_PKG is
	new SUBCLASS_INFO_GENERIC_PKG(
		BULLET_STATUS_TYPE,
		ACCESS_BULLET_STATUS_TYPE,
		255);

    use SUBCLASS_INFO_PKG;


    procedure CREATED(
	O		: in out OBJECTS.OBJECT_TYPE) is separate;


    procedure ABOUT_TO_DELETE(
	O		: in out OBJECTS.OBJECT_TYPE) is
    begin
	DELETE_SUBCLASS_INFO(O);
    end;


    procedure MOVE( O	: in out OBJECTS.OBJECT_TYPE;
		    ELAPSED_SINCE_LAST_MOVE	: SCALAR_PHYSICS.SECONDS) is
	separate;


    function FLIGHT_TIME(D : METRES) return SCALAR_PHYSICS.SECONDS is
    begin
	return SCALAR_PHYSICS.SECONDS(
		    SCALE_TYPE(D)/SCALE_TYPE(AVERAGE_AIRSPEED));
    end;


begin
    ADD_SUBPICTURE(BULLET_APPEARANCE,
	FURTHEREST_VISIBLE  => 1_500.0);

    ADD_POINTS(BULLET_APPEARANCE,
	VECTOR_OF_POSITION'(
	1 => (  0.0, 0.0, 0.0))	-- just a single point
	);
    FINISH_CREATING_SUBPICTURES(BULLET_APPEARANCE);

    ADD_POINTS(BULLET_APPEARANCE_FROM_TAPE,
	VECTOR_OF_POSITION'(
	(  0.0, 0.0, 0.0),
	(  0.0, INITIAL_AIRSPEED*SECONDS'(0.1), 0.0))
	);
    FINISH_CREATING_SUBPICTURES(BULLET_APPEARANCE_FROM_TAPE);

    declare
	D : BULLET_STATUS_TYPE renames
	    SUBCLASS_INFO_TO_ACCESS_STATUS(DEFAULT_SUBCLASS_INFO).all;
    begin
	null;
    end;
end;
