--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with SCALAR_PHYSICS, OBJECT_PHYSICS, INFO_MANAGER;
use  SCALAR_PHYSICS, OBJECT_PHYSICS, INFO_MANAGER;
package APPEARANCE_MANAGER is

    type PICTURE_TYPE;
    type ACCESS_PICTURE_TYPE is access PICTURE_TYPE;

    package PREALLOCATED_APPEARANCES_PKG is
	type PREALLOCATED_APPEARANCES_TYPE is
	    (BULLETS, MISSILES, AEROPLANES, MAGIC_CARPETS, NOT_PREALLOCATED);
    end;

    ----------------------------------------------------------------------------
    -- Create, create the subpictures, and delete an appearance
    --
    type ACCESS_APPEARANCE_TYPE is private;

    type VECTOR_OF_POSITION is
	array (POSITIVE range <>) of POSITION;

    function CREATE(
	PREALLOCATED_APPEARANCE : PREALLOCATED_APPEARANCES_PKG.PREALLOCATED_APPEARANCES_TYPE
				:= PREALLOCATED_APPEARANCES_PKG.NOT_PREALLOCATED
	) return APPEARANCE_INFO_TYPE;

    function TO_ACCESS_APPEARANCE_TYPE(
	APPEARANCE_INFO : APPEARANCE_INFO_TYPE
	) return ACCESS_APPEARANCE_TYPE;

    function CREATE return ACCESS_APPEARANCE_TYPE;

    procedure ADD_POINT(APPEARANCE  : ACCESS_APPEARANCE_TYPE;
			POINT	    : POSITION);

    procedure ADD_POINTS(APPEARANCE : ACCESS_APPEARANCE_TYPE;
			POINTS	    : VECTOR_OF_POSITION);

    procedure ADD_SUBPICTURE(APPEARANCE : ACCESS_APPEARANCE_TYPE;
	CLOSEST_VISIBLE     : METRES := 0.0;
	FURTHEREST_VISIBLE  : METRES := METRES'last);

    procedure FINISH_CREATING_SUBPICTURES(APPEARANCE : ACCESS_APPEARANCE_TYPE);

    procedure REOPEN_CREATING_SUBPICTURES(APPEARANCE : ACCESS_APPEARANCE_TYPE);

    procedure DELETE(APPEARANCE : in out ACCESS_APPEARANCE_TYPE);

    procedure DELETE_FIRST_SUBPICTURES(APPEARANCE : ACCESS_APPEARANCE_TYPE;
	N : NATURAL := 1);


    -- A way of getting the PICTURE, given an APPEARANCE.  This picture should
    -- be treated as a constant by the caller, and also can only be done after
    -- FINISH_CREATING_SUBPICTURES has been called.
    --
    function APPEARANCE_TO_PICTURE(APPEARANCE : ACCESS_APPEARANCE_TYPE)
	return ACCESS_PICTURE_TYPE;

    -- The MAX_RADIUS is the furtherest any point in this picture is from
    -- the origin, and can thus be used to decide if any of this picture has
    -- any lines than should be drawn at all.
    --
    function APPEARANCE_TO_MAX_RADIUS(APPEARANCE : ACCESS_APPEARANCE_TYPE)
	return METRES;

    ----------------------------------------------------------------------------
    -- A picture is a list of points that should be connected with lines
    -- to draw the resulting picture.

    -- Basically it is a set of line-drawing movements - start at POINTS(1),
    -- draw to POINTS(2), then to POINTS(3), etc.  Of course this demands that
    -- the object be connected, so instead we define the object as a list of
    -- connected subpictures, but the subpictures are not connected.

    subtype NATURAL_POINTS_RANGE is NATURAL range 0..100;
    subtype POSITIVE_POINTS_RANGE is NATURAL_POINTS_RANGE range 1..100;

    type PICTURE_TYPE is
	record
	    COUNT		: NATURAL_POINTS_RANGE  := 0;
	    CLOSEST_VISIBLE     : METRES		:= 0.0;
	    FURTHEREST_VISIBLE  : METRES		:= METRES'last;
	    NEXT_SUBPICTURE	: ACCESS_PICTURE_TYPE   := null;
	    POINTS		: VECTOR_OF_POSITION(POSITIVE_POINTS_RANGE);
	end record;

private

    pragma INLINE(APPEARANCE_TO_PICTURE);
    pragma INLINE(TO_ACCESS_APPEARANCE_TYPE);

    type APPEARANCE_TYPE;
    type ACCESS_APPEARANCE_TYPE is access APPEARANCE_TYPE;

end;
