--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    STANDARD_ATMOSPHERE, SCALAR_PHYSICS;
use
    STANDARD_ATMOSPHERE, SCALAR_PHYSICS;

pragma ELABORATE(
    STANDARD_ATMOSPHERE, SCALAR_PHYSICS);


package AEROPLANE_ENGINES is

    type ENGINE_HANDLE_TYPE is private;

    type ENGINE_MODE_TYPE is
	(MILITARY, MAXIMUM);

    function ENGINE_TYPE_VALUE(ENGINE_NAME : STRING) return ENGINE_HANDLE_TYPE;
    function ENGINE_TYPE_IMAGE(ENGINE : ENGINE_HANDLE_TYPE) return STRING;

    procedure GET_ENGINE_INFO(
	ENGINE	    : ENGINE_HANDLE_TYPE;

	THROTTLE    : SCALE_TYPE;
	ENGINE_MODE : ENGINE_MODE_TYPE;

	MACH	    : MACH_TYPE;
	DENSITY     : KILOGRAMS_PER_METRE_CUBED;

	THRUST	    : out NEWTONS;
	CONSUMPTION : out KILOGRAMS_PER_SECOND
	);

private
    type ENGINE_HANDLE_TYPE is new NATURAL;

end;
