--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with WEAPONS;

separate(AEROPLANE)
    procedure CREATED(
	O		: in out OBJECTS.OBJECT_TYPE)
    is

	AEROPLANE	: constant ACCESS_AEROPLANE_TYPE
			:= VARIOUS_PLANES.GET(
				VARIOUS_PLANES.GET_NAME(NATURAL(O.SUBCLASS)));

	AIRSPEED	: METRES_PER_SECOND;

    begin

	O.RADIUS	:= AEROPLANE.RADIUS;
	O.EXTRA_RADII	:= AEROPLANE.EXTRA_RADII;
	O.VIEW_LOCATION := AEROPLANE.VIEW_LOCATION;

	-- Filter out those not maintained by this simulator
	--
	if O.MAINTAINER /= THIS_SIMULATOR then return; end if;

	-- Complete the local info needed for this aeroplane
	--
	AIRSPEED := 0.0;
	if O.LOCATION.K > 0.0 then
	    --
	    -- Hack, better approach would be to estimate cruising speed
	    --
	    AIRSPEED := 150.0;
	end if;

	O.VELOCITY :=
	    (O.ORIENTATION.J*SCALE_TYPE(AIRSPEED))/
	    SCALAR_PHYSICS.SECONDS'(1.0);

	CREATE_SUBCLASS_INFO(O);

	declare
	    AEROPLANE_STATUS : AEROPLANE_STATUS_TYPE renames
		    SUBCLASS_INFO_PKG.SUBCLASS_INFO_TO_ACCESS_STATUS(
			O.SUBCLASS_INFO).all;
	begin

	    AEROPLANE_STATUS.AEROPLANE := AEROPLANE;
	    AEROPLANE_STATUS.FUEL_MASS := AEROPLANE.MAX_FUEL_MASS*
					    SCALE_TYPE(0.6);

	    -- HACK, should be from AEROPLANE
	    --
	    WEAPONS.RELOAD(
		4,	-- missiles
		200,	-- bullets (10 seconds at 20 updates per second)
		O);

	    O.APPEARANCE_INFO := AEROPLANE_STATUS.AEROPLANE.APPEARANCE_INFO;
	end;

    end;
