--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with AEROPLANE_DEBUGGING, VIEW_DIRECTION_CONTROL;
with TEXT_IO, INTEGER_TEXT_IO, FLOAT_TEXT_IO, LOGICAL_TO_FLOAT;

with SCALE_TYPE_MATH_LIB;

pragma ELABORATE(
    AEROPLANE_DEBUGGING,
    TEXT_IO, INTEGER_TEXT_IO, FLOAT_TEXT_IO, LOGICAL_TO_FLOAT,
    SCALE_TYPE_MATH_LIB);

separate(AEROPLANE)

    package body AUTOPILOT_PKG is


	SEQUENCE_NUMBER     : NATURAL := 0;
	DESIRED_ALTITUDE    : OBJECT_LOCATION_COORDINATE;
	DESIRED_BANK	    : SCALE_TYPE;


	procedure MOVE(
	    O			: in out OBJECTS.OBJECT_TYPE;
	    ELAPSED_SINCE_LAST_MOVE : SCALAR_PHYSICS.SECONDS) is

	    CS  : CONTROLS.CONTROL_SETTING_TYPE
		:= (
		    STICK_LEFT_RIGHT	=> 0.0,
		    STICK_FORWARD_BACK	=> 0.0,
		    FLAP		=> 0,
		    RUDDER		=> 0,
		    THROTTLE		=> CONTROLS.THROTTLE_TYPE'last,
		    AFTERBURNER_ON	=> TRUE,
		    SIGHT_ON		=> TRUE,
		    MODE		=> 0,

		    VD_CONTROL		=> (CONTROL_STATE=>
					      VIEW_DIRECTION_CONTROL.UNCHANGED),

		    TRIGGER1_PRESSED|
		    TRIGGER2_PRESSED|
		    TRIGGER1_RELEASED|
		    TRIGGER2_RELEASED 	=> FALSE,

		    CHANGE_PRESSED	=> FALSE,
		    QUIT_PRESSED	=> FALSE,

		    MESSAGE_LENGTH	=> 0,
		    MESSAGE_TEXT	=> (others=>' ')
		    );
	begin

	    -- Keep track of which aeroplane is being controlled (currently
	    -- only one may be).  If another aeroplane is selected, change to
	    -- it.
	    --
	    if SEQUENCE_NUMBER /= O.SEQUENCE_NUMBER then
		SEQUENCE_NUMBER := O.SEQUENCE_NUMBER;

		-- autopilot package tries to fly circles at this altitude/bank
		--
		DESIRED_ALTITUDE := 10_000.0;
		DESIRED_BANK	 := 0.5;

	    end if;

	    -- Make sure the AEROPLANE_STATUS is correct
	    --
	    if O.SUBCLASS_INFO = 0 then 
		MOVE(O, 0.0, CS);
	    end if;

	    -- pick what to do
	    --
	    declare
		use CONTROLS, WORLD_PHYSICS;

		AST : AEROPLANE_STATUS_TYPE
		    renames SUBCLASS_INFO_PKG.SUBCLASS_INFO_TO_ACCESS_STATUS(
				O.SUBCLASS_INFO).all;

		STALL_PITCH,
		PITCH,
		ROLL : SCALE_TYPE;

		procedure LIMIT(L : SCALE_TYPE; S : in out SCALE_TYPE) is
		begin
		    if S < -L then S := -L;
		    elsif L < S then S := L;
		    end if;
		end;

	    begin
		-- Use a simple feedback to keep plane flying flat at the right
		-- altitude.
		--
		-- pitch
		--
		PITCH := (SCALE_TYPE(O.LOCATION.K)-SCALE_TYPE(DESIRED_ALTITUDE))
			    /SCALE_TYPE(1_000.0);

		LIMIT(0.5, PITCH);

		PITCH := PITCH +
		    SCALE_TYPE(O.VELOCITY.K)/
		      SCALE_TYPE_MATH_LIB.SQRT(
			    SCALE_TYPE(O.VELOCITY.I)**2 +
			    SCALE_TYPE(O.VELOCITY.J)**2 );

		LIMIT(SCALE_TYPE(0.3), PITCH);
		    -- Hack, this is a very crude estimate of the stall AoA.

		CS.STICK_FORWARD_BACK := STICK_FORWARD_BACK_TYPE(PITCH);

		-- roll
		--
		ROLL := SCALE_TYPE(O.ORIENTATION.I.K) - DESIRED_BANK;
		LIMIT(SCALE_TYPE(STICK_LEFT_RIGHT_TYPE'last), ROLL);

		CS.STICK_LEFT_RIGHT := STICK_LEFT_RIGHT_TYPE(ROLL);

	    end;

	    -- Do it
	    --
	    MOVE(O, ELAPSED_SINCE_LAST_MOVE, CS);
	end;

    end;
