--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    TRIG, SCALAR_PHYSICS, ANGULAR_PHYSICS, OBJECT_PHYSICS, WORLD_PHYSICS,
    STANDARD_ATMOSPHERE, FIX_BASIS,
    --
    OBJECTS, APPEARANCE_MANAGER, INFO_MANAGER,
    AEROPLANE_ENGINES, LIFT_DRAG_CURVE_MANAGER,
    --
    SUBCLASS_INFO_GENERIC_PKG,
    LOGICAL_TO_FLOAT;

use
    TRIG, SCALAR_PHYSICS, ANGULAR_PHYSICS, WORLD_PHYSICS,
    --
    OBJECTS, APPEARANCE_MANAGER, INFO_MANAGER,
    AEROPLANE_ENGINES, LIFT_DRAG_CURVE_MANAGER;

pragma ELABORATE(
    TRIG, SCALAR_PHYSICS, ANGULAR_PHYSICS, OBJECT_PHYSICS, WORLD_PHYSICS,
    STANDARD_ATMOSPHERE, FIX_BASIS,
    --
    OBJECTS, APPEARANCE_MANAGER, INFO_MANAGER,
    AEROPLANE_ENGINES, LIFT_DRAG_CURVE_MANAGER,
    --
    SUBCLASS_INFO_GENERIC_PKG,
    LOGICAL_TO_FLOAT);


package body AEROPLANE is

    subtype SECONDS is SCALAR_PHYSICS.SECONDS;

    PARTIAL_TIME_DELTA : constant SECONDS
	:= SECONDS(LOGICAL_TO_FLOAT("FCTM_AEROPLANE_AERODYNAMICS_STEP", 0.03));

    type AEROPLANE_NAME_TYPE is access STRING;

    type AEROPLANE_TYPE is
	record
	    NAME			    : AEROPLANE_NAME_TYPE;
	    APPEARANCE_INFO		    : APPEARANCE_INFO_TYPE;
	    VIEW_LOCATION		    : OBJECT_PHYSICS.POSITION;

	    -- Mass issues
	    --
	    EMPTY_MASS			    : KILOGRAMS;
	    DEFAULT_FUEL_MASS,
	    MAX_FUEL_MASS		    : KILOGRAMS;

	    -- Engine issues
	    --
	    ENGINE_COUNT		    : SCALE_TYPE;
	    ENGINE			    : ENGINE_HANDLE_TYPE;
	    
	    -- Main wings
	    --
	    SIN_DIHEDRAL_ANGLE,
	    COS_DIHEDRAL_ANGLE,
	    SIN_PLACEMENT_ANGLE,
	    COS_PLACEMENT_ANGLE,
	    SIN_SWEEP_ANGLE,
	    COS_SWEEP_ANGLE		    : SCALE_TYPE;

	    WING_AREA			    : METRES_SQUARED;
	    WING_MOMENT_LENGTH		    : METRES;
	    WING_PITCH_MOMENT_LENGTH	    : METRES;
	    WING_LIFT_DRAG_CURVE	    : ACCESS_LIFT_AND_DRAG_CURVE_TYPE;
	    FLAPS_AND_SLATS_EFFECT	    : SCALE_TYPE range 0.0 .. 1.0;
	    WING_ASPECT_RATIO		    : SCALE_TYPE;
	    PARTIAL_LAMBDA_50		    : SCALE_TYPE;  -- see MCAD pg 44

	    -- Body
	    --
	    EXTRA_ZERO_DRAG		    : SCALE_TYPE;
	    BODY_AREA			    : METRES_SQUARED;
	    BODY_LIFT_DRAG_CURVE	    : ACCESS_LIFT_AND_DRAG_CURVE_TYPE;

	    -- Tail
	    --
	    TAIL_MOMENT_LENGTH		    : METRES;
	    MAX_RUDDER_DEFLECTION,
	    MAX_ELEVATOR_DEFLECTION 	    : RADIANS;

	    -- Misc.
	    --
	    ROTATE_SPEED		    : METRES_PER_SECOND;
	    LANDING_HEIGHT		    : OBJECTS.OBJECT_LOCATION_COORDINATE;
	    ANGULAR_ROLL_FACTOR 	    : SCALE_TYPE;

	    POSITIVE_G_LIMIT,
	    NEGATIVE_G_LIMIT		    : SCALE_TYPE;

	    RADIUS			    : METRES;
	    EXTRA_RADII 		    : OBJECTS.VECTOR_OF_EXTRA_RADIUS_TYPE(1..5);

	    CAS_FLAP_LIMIT		    : METRES_PER_SECOND;
	    FLAP_G_LIMIT		    : SCALE_TYPE;

	    CAS_AEROLON_LIMIT		    : METRES_PER_SECOND;
	    AEROLON_PER_WING_AREA	    : SCALE_TYPE range 0.0 .. 1.0;
	    CAS_PITCH_LIMIT		    : METRES_PER_SECOND;
	end record;

    type ACCESS_AEROPLANE_TYPE is access AEROPLANE_TYPE;

    type AEROPLANE_STATUS_TYPE is
	record
	    AEROPLANE	    : ACCESS_AEROPLANE_TYPE;

	    FUEL_MASS	    : KILOGRAMS 			    := 0.0;
	    TIME_DELTA_CARRIED_FORWARD : SECONDS		    := 0.0;

	    ROLL_RATE,
	    PITCH_RATE,
	    YAW_RATE	    : ANGULAR_PHYSICS.RADIANS_PER_SECOND    := 0.0;

	    FLAP_CONTROL,
	    PITCH_CONTROL,
	    ROLL_CONTROL,
	    THRUST_CONTROL,
	    YAW_CONTROL,
	    TAIL_EFFECTIVENESS : SCALE_TYPE;

	    OBJECT_RELATIVE_VELOCITY    : OBJECT_PHYSICS.VELOCITY;

	    DENSITY	    : KILOGRAMS_PER_METRE_CUBED;
	    MACH	    : STANDARD_ATMOSPHERE.MACH_TYPE;
	    THRUST	    : NEWTONS;
	    CL_ALPHA_LEFT   : SCALE_TYPE;
	    CL_ALPHA_RIGHT  : SCALE_TYPE;

	    -- For testing, not used in normal simulation
	    --
	    DRAG	    : NEWTONS;
	    CD_CL_LEFT	    : LIFT_DRAG_CURVE_MANAGER.LIFT_DRAG_OUTPUTS;
	    CD_CL_RIGHT     : LIFT_DRAG_CURVE_MANAGER.LIFT_DRAG_OUTPUTS;

	    -- For instruments
	    --
	    AoA,
	    AoY 	    : RADIANS				    := 0.0;

	    AoA_MAX,
	    Gs_FELT	    : SCALE_TYPE			    := 1.0;
	end record;


    type ACCESS_AEROPLANE_STATUS_TYPE is access AEROPLANE_STATUS_TYPE;

    package SUBCLASS_INFO_PKG is
	new SUBCLASS_INFO_GENERIC_PKG(
		AEROPLANE_STATUS_TYPE,
		ACCESS_AEROPLANE_STATUS_TYPE,
		255);

    use SUBCLASS_INFO_PKG;


    function SKEW(S : SCALE_TYPE) return SCALE_TYPE;	pragma INLINE(SKEW);

    function SKEW(S : SCALE_TYPE) return SCALE_TYPE is
    begin
	if abs(S) < 0.3 then
	    return (S*abs(S))/0.3;
	else
	    return S;
	end if;
    end;


    procedure ABOUT_TO_DELETE(O : in out OBJECTS.OBJECT_TYPE) is
    begin
	DELETE_SUBCLASS_INFO(O);
    end;


    procedure SET_O_VELOCITY(
	O			: OBJECTS.OBJECT_TYPE;
	AEROPLANE_STATUS	: in out AEROPLANE_STATUS_TYPE) is separate;


    procedure SET_INSTRUMENTS(O  : in OBJECTS.OBJECT_TYPE) is separate;


    procedure ENGINE_THRUST_V_MACH_AND_ALT(
	AEROPLANE_STATUS    : AEROPLANE_STATUS_TYPE;
	ALTITUDE	    : METRES;
	TIME_DELTA	    : SECONDS;
	AFTERBURNER_ON	    : BOOLEAN;
	THRUST		    : out NEWTONS;
	BURNT		    : out KILOGRAMS) is separate;


    procedure MOVE_DELTA(
		    TIME_DELTA		    : SECONDS;
                    CS			    : CONTROLS.CONTROL_SETTING_TYPE;
		    O			    : in out OBJECTS.OBJECT_TYPE;
		    AEROPLANE_STATUS	    : in out AEROPLANE_STATUS_TYPE;
		    MAIN_WING_LIFT_DRAG_INPUTS,
		    BODY_LIFT_DRAG_INPUTS   : in out LIFT_DRAG_CURVE_MANAGER.LIFT_DRAG_INPUTS
		    ) is separate;


    procedure MOVE( O			    : in out OBJECTS.OBJECT_TYPE;
		    ELAPSED_SINCE_LAST_MOVE : SCALAR_PHYSICS.SECONDS;
		    CS			    : in out CONTROLS.CONTROL_SETTING_TYPE
		    ) is separate;


    package VARIOUS_PLANES is
	function GET_NAME(I : POSITIVE) return STRING;
	function GET(NAME : STRING) return ACCESS_AEROPLANE_TYPE;
    end;


    package body VARIOUS_PLANES is separate;


    procedure CREATED(
	O		: in out OBJECTS.OBJECT_TYPE) is separate;


    procedure TEST_POINT is separate;


    package AUTOPILOT_PKG is
	procedure MOVE(
	    O			: in out OBJECTS.OBJECT_TYPE;
	    ELAPSED_SINCE_LAST_MOVE : SCALAR_PHYSICS.SECONDS);
    end;

    package body AUTOPILOT_PKG is separate;

    procedure MOVE_CONTROLLED_BY_AUTOPILOT(
	O			: in out OBJECTS.OBJECT_TYPE;
	ELAPSED_SINCE_LAST_MOVE : SCALAR_PHYSICS.SECONDS) is
    begin
	AUTOPILOT_PKG.MOVE(O, ELAPSED_SINCE_LAST_MOVE);
    end;


begin

    declare
	D : AEROPLANE_STATUS_TYPE renames
	    SUBCLASS_INFO_TO_ACCESS_STATUS(
		DEFAULT_SUBCLASS_INFO).all;
    begin
	D.AEROPLANE := VARIOUS_PLANES.GET("F-4");
	D.FUEL_MASS := D.AEROPLANE.MAX_FUEL_MASS*SCALE_TYPE(0.6);
    end;

end;
