--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


with
    LIFT_DRAG_CURVE_MANAGER, VARIOUS_AEROPLANES_DATA,
    SELECT_CRAFT, MENU_MANAGER;
use 
    LIFT_DRAG_CURVE_MANAGER, VARIOUS_AEROPLANES_DATA,
    SELECT_CRAFT, MENU_MANAGER;

with
    SCALAR_PHYSICS, TRIG, SCALE_TYPE_TRIG;
use
    SCALAR_PHYSICS, TRIG, SCALE_TYPE_TRIG;

with PHYSICAL_UNITS;

pragma ELABORATE(
    LIFT_DRAG_CURVE_MANAGER, VARIOUS_AEROPLANES_DATA,
    SELECT_CRAFT, MENU_MANAGER,
    SCALAR_PHYSICS, TRIG, SCALE_TYPE_TRIG,
    PHYSICAL_UNITS);

separate(AEROPLANE)
    package body VARIOUS_PLANES is

	PLANE_DATA : VECTOR_OF_PLANE_DATA_TYPE renames
	    VARIOUS_AEROPLANES_DATA.PLANE_DATA.all;

	NO_SUCH_AEROPLANE : exception;

	function GET_NAME(I : POSITIVE) return STRING is
	begin
	    if I in PLANE_DATA'range then
		declare
		    N : STRING renames PLANE_DATA(I).NAME;
		    L : POSITIVE := N'last;
		begin
		    while L > N'first and then N(L) = ' ' loop
			L := L-1;
		    end loop;
		    return N(N'first..L);
		end;
	    else
		return "";
	    end if;
	end GET_NAME;

	function GET(NAME : STRING) return ACCESS_AEROPLANE_TYPE is
	    NAME_6  : constant STRING := NAME & (NAME'last+1..6=>' ');
	begin
	    for I in PLANE_DATA'range loop
		declare
		    DEGREES_TO_RADIANS : constant RADIANS
			    := RADIANS(2.0*TRIG.PI/360.0);

		    A	    : ACCESS_AEROPLANE_TYPE;
		    D	    : PLANE_DATA_TYPE renames PLANE_DATA(I);

		    MASS_WITH_MAX_FUEL : KILOGRAMS
			    := (D.WING_LOADING*D.WING_AREA)/
				METRES_PER_SECOND_SQUARED(PHYSICAL_UNITS.G);
		    MAX_FUEL_MASS : KILOGRAMS;
		    DEFAULT_FUEL_MASS_RATIO : constant SCALE_TYPE := 0.34;

		    Ci	    : constant METRES
			    := (D.SPAN/SCALE_TYPE'(2.0*D.ASPECT_RATIO))*
				SCALE_TYPE'(4.0/(1.0+D.TAPER_RATIO));
		    MAC     : constant METRES
			    := (Ci*SCALE_TYPE(2.0/3.0))*
				((1.0+D.TAPER_RATIO+D.TAPER_RATIO**2)/
				 (1.0+D.TAPER_RATIO));	

		    WING_MOMENT_LENGTH : constant METRES
			    := D.SPAN/SCALE_TYPE(4.0); -- HACK two wings, 1/2way

		    PARTIAL_LAMBDA_50 : constant SCALE_TYPE
			    := 2.0/D.ASPECT_RATIO*
				 (1.0 - D.TAPER_RATIO)/
				 (1.0 + D.TAPER_RATIO);
		begin
		    if D.NAME = NAME_6 then

			MAX_FUEL_MASS := D.MAX_FUEL_MASS;
			if MAX_FUEL_MASS = 0.0 then
			    MAX_FUEL_MASS :=
				MASS_WITH_MAX_FUEL*DEFAULT_FUEL_MASS_RATIO;
			end if;

			A := new AEROPLANE_TYPE'(


NAME			=> new STRING'(NAME_6),
APPEARANCE_INFO 	=> D.APPEARANCE_INFO,
VIEW_LOCATION		=> D.VIEW_LOCATION,

-- Mass issues
--
EMPTY_MASS		=> MASS_WITH_MAX_FUEL-MAX_FUEL_MASS,
DEFAULT_FUEL_MASS	=> MAX_FUEL_MASS*SCALE_TYPE'(0.5),
MAX_FUEL_MASS		=> MAX_FUEL_MASS,

-- Engine issues
--
ENGINE_COUNT		=> SCALE_TYPE(D.ENGINE_COUNT),
ENGINE			=> D.ENGINE,

-- Main wings
--
SIN_DIHEDRAL_ANGLE 	=> SIN(RADIANS(D.DIHEDRAL)*DEGREES_TO_RADIANS),
COS_DIHEDRAL_ANGLE	=> COS(RADIANS(D.DIHEDRAL)*DEGREES_TO_RADIANS),
SIN_PLACEMENT_ANGLE 	=> SIN(RADIANS(D.WING_PLACEMENT)*DEGREES_TO_RADIANS),
COS_PLACEMENT_ANGLE	=> COS(RADIANS(D.WING_PLACEMENT)*DEGREES_TO_RADIANS),
SIN_SWEEP_ANGLE 	=> SIN(RADIANS(D.SWEEPBACK_LEAD)*DEGREES_TO_RADIANS),
COS_SWEEP_ANGLE		=> COS(RADIANS(D.SWEEPBACK_LEAD)*DEGREES_TO_RADIANS),

WING_AREA		=> D.WING_AREA/SCALE_TYPE(2.0),     -- two wings...
WING_MOMENT_LENGTH	=> WING_MOMENT_LENGTH,
WING_PITCH_MOMENT_LENGTH=> D.SPAN/SCALE_TYPE(4.0*20.0),	    -- hack
WING_LIFT_DRAG_CURVE	=> GET_LIFT_DRAG_CURVE(D.AEROFOIL_NAME.NAME),
FLAPS_AND_SLATS_EFFECT	=> SCALE_TYPE(5*BOOLEAN'pos(D.LIFT_DEVICES = F ) +
				      6*BOOLEAN'pos(D.LIFT_DEVICES = FS))/6.0,
WING_ASPECT_RATIO	=> D.ASPECT_RATIO,
PARTIAL_LAMBDA_50	=> PARTIAL_LAMBDA_50,

-- Body
--
EXTRA_ZERO_DRAG 	=> D.EXTRA_ZERO_DRAG,
BODY_AREA		=> 0.0, 			    -- HACK
BODY_LIFT_DRAG_CURVE	=> GET_LIFT_DRAG_CURVE(""),	    -- HACK

-- Tail
--
TAIL_MOMENT_LENGTH	=> MAC*D.IH_PER_C,
MAX_RUDDER_DEFLECTION	=> RADIANS(RADIANS_PER_CIRCLE)/SCALE_TYPE'(36.0),   -- HACK
MAX_ELEVATOR_DEFLECTION => D.MAX_ELEVATOR_DEFLECTION,

-- Misc
--
ROTATE_SPEED		=> D.ROTATE_SPEED,
LANDING_HEIGHT		=> OBJECTS.OBJECT_LOCATION_COORDINATE'(2.0), -- metres
ANGULAR_ROLL_FACTOR	=> SCALE_TYPE(WING_MOMENT_LENGTH)/SCALE_TYPE'(1.0**2),

POSITIVE_G_LIMIT	=> D.POSITIVE_G_LIMIT,
NEGATIVE_G_LIMIT	=> D.NEGATIVE_G_LIMIT,
RADIUS			=> D.RADIUS,
EXTRA_RADII		=> D.EXTRA_RADII,
CAS_FLAP_LIMIT		=> D.CAS_FLAP_LIMIT,
FLAP_G_LIMIT		=> D.FLAP_G_LIMIT,
CAS_AEROLON_LIMIT	=> D.CAS_AEROLON_LIMIT,
AEROLON_PER_WING_AREA	=> D.AEROLON_PER_WING_AREA,
CAS_PITCH_LIMIT 	=> D.CAS_PITCH_LIMIT

			    );

			return A;
		    end if;
		end;
	    end loop;
	    raise NO_SUCH_AEROPLANE;
	end GET;

    begin
	declare
	    NAME_MENU : MENU_MANAGER.MENU_TYPE;
	begin
	    MENU_MANAGER.CREATE("Aeroplanes", NAME_MENU);

	    for I in POSITIVE loop
		declare
		    NAME : constant STRING := VARIOUS_PLANES.GET_NAME(I);
		begin
		    exit when NAME = "";
		    MENU_MANAGER.APPEND(NAME, I, NAME_MENU);
		end;
	    end loop;

	    SELECT_CRAFT.PROVIDE_CLASS_TO_SUBCLASS_MENU(
		OBJECTS.AEROPLANE, NAME_MENU);
	end;
    end;
