--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


separate(AEROPLANE.MOVE_DELTA)
	procedure SUM_ACCELERATIONS is

	    OR_A_I,
	    OR_A_J,
	    OR_A_K : METRES_PER_SECOND_SQUARED;

	    WR_A_I,
	    WR_A_J,
	    WR_A_K : METRES_PER_SECOND_SQUARED;

	begin
	    -- Compute object-relative acceleration caused by surfaces
	    --
	    OR_A_I :=	L(LW).I + L(RW).I+ --+ L(B).I + 
			D(LW).I + D(RW).I; --+ D(B).I;

	    OR_A_J :=	L(LW).J + L(RW).J+ --+ L(B).J + 
			D(LW).J + D(RW).J; --+ D(B).J;

	    OR_A_K :=	L(LW).K + L(RW).K+ --+ L(B).K + 
			D(LW).K + D(RW).K; --+ D(B).K;

	    -- Record the drag
	    --
	    AEROPLANE_STATUS.DRAG := MASS*OR_A_J;

	    -- Add in engines
	    --
	    OR_A_J := OR_A_J + AEROPLANE_STATUS.THRUST/MASS;

	    -- If not trying to accelerate then hit the brakes...
	    --
	    if  IN_GROUND_CONTACT
	    and then not CS.AFTERBURNER_ON
	    and then THRUST_CONTROL = 0.0
	    then
		if OBJECT_RELATIVE_VELOCITY.J > 0.0 then
		    OR_A_J := OR_A_J - 
				METRES_PER_SECOND_SQUARED(PHYSICAL_UNITS.G)*
				SCALE_TYPE'(0.2);
		end if;
	    end if;

	    -- Record the Gs felt by the pilot/aeroplane
	    --
	    AEROPLANE_STATUS.Gs_FELT :=
		SCALE_TYPE(OR_A_K)/SCALE_TYPE(PHYSICAL_UNITS.G);

	    -- Project to world relative
	    --
	    WR_A_I :=	OR_A_I*SCALE_TYPE(O.ORIENTATION.I.I)  +
			OR_A_J*SCALE_TYPE(O.ORIENTATION.J.I)  +
			OR_A_K*SCALE_TYPE(O.ORIENTATION.K.I);

	    WR_A_J :=	OR_A_I*SCALE_TYPE(O.ORIENTATION.I.J)  +
			OR_A_J*SCALE_TYPE(O.ORIENTATION.J.J)  +
			OR_A_K*SCALE_TYPE(O.ORIENTATION.K.J);

	    WR_A_K :=	OR_A_I*SCALE_TYPE(O.ORIENTATION.I.K)  +
			OR_A_J*SCALE_TYPE(O.ORIENTATION.J.K)  +
			OR_A_K*SCALE_TYPE(O.ORIENTATION.K.K);

	    -- Gravity
	    --
	    WR_A_K := WR_A_K-METRES_PER_SECOND_SQUARED(PHYSICAL_UNITS.G);

	    -- In ground contact?
	    --
	    if IN_GROUND_CONTACT then

		-- Don't accelerate downwards...
		--
		if WR_A_K < 0.0 then WR_A_K := 0.0; end if;

	    end if;

	    ACCELERATION.I := WR_A_I;
	    ACCELERATION.J := WR_A_J;
	    ACCELERATION.K := WR_A_K;
	end;
pragma SUPPRESS_ALL;
