--***********************************************************************
--									*
--	COPYRIGHT 1992		DIGITAL EQUIPMENT CORPORATION		*
--									*
--   This software was written by Bevin Brett, of Digital Equipment	*
--   Corporation.							*
--									*
--   Digital assumes no responsibility AT ALL for the use or reliability*
--   of this software.							*
--									*
--   Redistribution and use in source and binary forms are permitted	*
--   provided that this entire heading from --*** to --*** are          *
--   duplicated in all such forms and that any documentation,		*
--   advertising materials, and other materials related to such		*
--   distribution and use acknowledge that the software was developed	*
--   by Digital Equipment Corporation. The name of Digital Equipment	*
--   Corporation may not be used to endorse or promote products derived	*
--   from this software without specific prior written permission.	*
--									*
--   THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR	*
--   IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED	*
--   WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.*
--									*
--***********************************************************************


separate(AEROPLANE.MOVE_DELTA)
	procedure SET_SURFACE_VELOCITIES(MAIN_WINGS_ONLY : BOOLEAN) is

	    MOVI : constant METRES_PER_SECOND := -OBJECT_RELATIVE_VELOCITY.I;
	    MOVJ : constant METRES_PER_SECOND := -OBJECT_RELATIVE_VELOCITY.J;
	    MOVK : constant METRES_PER_SECOND := -OBJECT_RELATIVE_VELOCITY.K;

	    ROLL_EFFECT : constant METRES_PER_SECOND
		:= METRES_PER_SECOND(
		    SCALE_TYPE(AEROPLANE_STATUS.ROLL_RATE)*
		    SCALE_TYPE(A_T.WING_MOMENT_LENGTH));

	    YAW_EFFECT : constant METRES_PER_SECOND
		:= METRES_PER_SECOND(
		    SCALE_TYPE(AEROPLANE_STATUS.YAW_RATE)*
		    SCALE_TYPE(A_T.WING_MOMENT_LENGTH));

	begin

	-- Make the velocity of each the opposite to the object's velocity
	--
	V(RW).I := MOVI;
	V(RW).J := MOVJ - YAW_EFFECT;
	V(RW).K := MOVK - ROLL_EFFECT;

	V(LW).I := MOVI;
	V(LW).J := MOVJ + YAW_EFFECT;
	V(LW).K := MOVK + ROLL_EFFECT;

--	if not MAIN_WINGS_ONLY then
--	    V(B).I	:= MOVI;
--	    V(B).J	:= MOVJ;
--	    V(B).K	:= MOVK;
--	end if;

	end;
